jQuery(document).ready(function ($) {
    $('#category').change(function () {
        var parent_id = $(this).val();
        var subcategorySelect = $('#subcategory');

        if (parent_id) {
            $.ajax({
                type: 'POST',
                url: ajaxsearch.ajaxurl,
                data: {
                    action: 'fetch_subcategories',
                    parent_id: parent_id
                },
                success: function (response) {
                    subcategorySelect.html(response);
                    subcategorySelect.prop('disabled', false);
                }
            });
        } else {
            subcategorySelect.html('<option value="">Select a category first</option>');
            subcategorySelect.prop('disabled', true);
        }
    });

    $('#ajax-search-form').submit(function (e) {
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: ajaxsearch.ajaxurl,
            data: $(this).serialize() + '&action=custom_ajax_search',
            success: function (response) {
                $('#ajax-search-results').html(response);
            }
        });
    });
});
