document.addEventListener('DOMContentLoaded', function () {
    const button = document.getElementById('popup-button');
    const popup = document.getElementById('popup');
    const overlay = document.getElementById('popup-overlay');
    const closeButton = document.getElementById('close-popup');
    const popupContent = document.getElementById('popup-content');

    // Show popup and load content
    button.addEventListener('click', function (e) {
        e.preventDefault();

        // Show loading text while waiting for the response
        popupContent.innerHTML = '<p>Chargement du contenu...</p>';
        popup.style.display = 'block';
        overlay.style.display = 'block';

        // Fetch the post content via AJAX
        fetch(popupAjax.ajax_url, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                action: 'load_post_content',
                post_id: popupAjax.post_id,
            }),
        })
            .then(response => response.text())
            .then(data => {
                popupContent.innerHTML = data; // Insert content into the popup
            })
            .catch(error => {
                console.error('Error:', error);
                popupContent.innerHTML = '<p>Error loading content.</p>';
            });
    });

    // Close popup
    closeButton.addEventListener('click', function () {
        popup.style.display = 'none';
        overlay.style.display = 'none';
    });

    // Close popup when clicking the overlay
    overlay.addEventListener('click', function () {
        popup.style.display = 'none';
        overlay.style.display = 'none';
    });
});
