<?php
// Enqueue styles from the parent theme
function kadence_child_enqueue_styles() {
    wp_enqueue_style('kadence-parent-style', get_template_directory_uri() . '/style.css');
}
add_action('wp_enqueue_scripts', 'kadence_child_enqueue_styles');



function display_all_acf_fields() {
    if (function_exists('get_field_objects')) {
        $fields = get_field_objects();
        if ($fields) {
            echo '<div class="acf-fields">';
            foreach ($fields as $field_name => $field) {
                echo '<div class="acf-field">';
                echo '<strong>' . esc_html($field['label']) . ':</strong> ';
                
                // Check if the field value is an array
                if (is_array($field['value'])) {
                    echo '<ul>';
                    foreach ($field['value'] as $item) {
                        echo '<li>' . esc_html($item) . '</li>';
                    }
                    echo '</ul>';
                } else {
                    echo esc_html($field['value']);
                }
                echo '</div>';
            }
            echo '</div>';
        } else {
           
        }
    }
}



// Register the search form shortcode
function custom_ajax_search_form() {
    // Get all top-level categories
    $categories = get_categories([
        'hide_empty' => 0,
        'parent' => 0,
    ]);

    ob_start(); ?>
    <div id="search-wrapper">
        <!-- Search Form -->
        <form id="ajax-search-form" method="POST">
            <label for="s">Mot-clé:</label>
            <input type="text" id="s" name="s" placeholder="Recherche..." />

            <label for="category">Category:</label>
            <select id="category" name="cat">
                <option value="">All Categories</option>
                <?php foreach ($categories as $category): ?>
                    <option value="<?php echo esc_attr($category->term_id); ?>">
                        <?php echo esc_html($category->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <label for="subcategory">Sub-Category:</label>
            <select id="subcategory" name="subcat" disabled>
                <option value="">Select a category first</option>
            </select>

            <button type="submit">Search</button>
        </form>

        <div id="ajax-search-results"></div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('ajax_search_form', 'custom_ajax_search_form');

// Handle AJAX for fetching subcategories
function custom_get_subcategories() {
    $parent_id = intval($_POST['parent_id']);
    $subcategories = get_categories([
        'hide_empty' => 0,
        'parent' => $parent_id,
    ]);

    if (!empty($subcategories)) {
        foreach ($subcategories as $subcategory) {
            echo '<option value="' . esc_attr($subcategory->term_id) . '">' . esc_html($subcategory->name) . '</option>';
        }
    } else {
        echo '<option value="">No subcategories available</option>';
    }

    wp_die();
}
add_action('wp_ajax_get_subcategories', 'custom_get_subcategories');
add_action('wp_ajax_nopriv_get_subcategories', 'custom_get_subcategories');

// Handle AJAX Search Requests
function custom_ajax_search_handler() {
    $keyword = sanitize_text_field($_POST['s'] ?? '');
    $category = intval($_POST['cat'] ?? 0);
    $subcategory = intval($_POST['subcat'] ?? 0);

    $args = [
        's' => $keyword,
        'post_status' => 'publish',
        'posts_per_page' => -1,
    ];

    // Use subcategory if selected, otherwise fall back to category
    if ($subcategory) {
        $args['cat'] = $subcategory;
    } elseif ($category) {
        $args['cat'] = $category;
    }

    $query = new WP_Query($args);

    echo '<p><strong>' . $query->found_posts . ' result(s) found.</strong></p>';

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            echo '<div class="search-result-item">';
            echo '<h3><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></h3>';
            echo '<p>' . esc_html(get_the_excerpt()) . '</p>';
            echo '</div>';
        }
    } else {
        echo '<p>No results found.</p>';
    }

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_custom_ajax_search', 'custom_ajax_search_handler');
add_action('wp_ajax_nopriv_custom_ajax_search', 'custom_ajax_search_handler');

// Enqueue JavaScript
function enqueue_ajax_search_scripts() {
    wp_enqueue_script('ajax-search', get_template_directory_uri() . '/ajax-search.js', ['jquery'], null, true);
    wp_localize_script('ajax-search', 'ajaxsearch', [
        'ajaxurl' => admin_url('admin-ajax.php'),
    ]);
}
add_action('wp_enqueue_scripts', 'enqueue_ajax_search_scripts');


// Register Shortcodes for "Print / Save as PDF" and "Download Post as Word"
function register_post_buttons_shortcode() {
    add_shortcode('post_buttons', 'display_post_buttons');
}
add_action('init', 'register_post_buttons_shortcode');

// Display Print and Word Export Buttons
function display_post_buttons($atts) {
    ob_start(); ?>

    <div class="post-buttons">
        <?php if (is_single()) { ?>
            <!-- Print / Save as PDF Button -->
            <button id="printButton" onclick="printPostContent()" style="display: block; background: #0073aa; color: white; border: none; cursor: pointer;"> Télécharger PDF Format</button>

            <script>
                function printPostContent() {
                    var content = document.querySelector(".entry-content") || document.querySelector(".post-content") || document.querySelector(".post");
                    if (content) {
                        var printButton = document.getElementById("printButton");
                        printButton.style.display = "none"; // Hide button before printing
						
                        var newWin = window.open("", "", "width=800,height=600");
                        newWin.document.write("<html><head><style>body{font-family:Arial,sans-serif;line-height:1.6;margin:20px;} img{max-width:100%; height:auto;} .post-buttons{display:none;}</style></head><body>");
                        newWin.document.write(content.innerHTML);
                        newWin.document.write("</body></html>");
                        newWin.document.close();
                        newWin.print();

                        printButton.style.display = "block"; // Show button again after printing
                    } else {
                        alert("Content not found!");
                    }
                }
            </script>
        <?php } ?>

        <!-- Download Post as Word Button -->
        <form method="POST" action="<?php echo esc_url(add_query_arg('export_post', get_the_ID())); ?>">
            <input id="wordButton" type="submit" name="export_post" value="Télécharger Word Format" class="button button-primary"/>
        </form>
		
		<a href="#" id="popup-button" class="custom-button">Résumé IA</a>
    </div>

    <?php
    return ob_get_clean();
}


// Handle Word Export Request
add_action('template_redirect', 'handle_post_export');

function handle_post_export() {
    if (isset($_GET['export_post'])) {
        $post_id = intval($_GET['export_post']);

        if ($post_id > 0) {
            export_post_to_word($post_id);
        }
    }
}
// Function to export the post to Word format

function export_post_to_word($post_id) {
    $post = get_post($post_id);

    if (!$post) {
        return;
    }

    // Start Word document content
    $content = "<html xmlns:w='urn:schemas-microsoft-com:office:word'><body>";
    $content .= "<h1>" . esc_html(get_the_title($post)) . "</h1>"; // Post title

    // Remove content inside the class "post-buttons"
    $content .= preg_replace('/<div[^>]*class="post-buttons"[^>]*>.*?<\/div>/is', '', apply_filters('the_content', $post->post_content));

    // Append ACF fields
    if (function_exists('get_field_objects')) {
        $fields = get_field_objects($post_id); // Get ACF fields for the specific post
        if ($fields) {
            $content .= '<div class="acf-fields">';
            foreach ($fields as $field_name => $field) {
                $content .= '<div class="acf-field">';
                $content .= '<strong>' . esc_html($field['label']) . ':</strong> ';

                // Check if the field value is an array
                if (is_array($field['value'])) {
                    $content .= '<ul>';
                    foreach ($field['value'] as $item) {
                        $content .= '<li>' . esc_html($item) . '</li>';
                    }
                    $content .= '</ul>';
                } else {
                    $content .= esc_html($field['value']);
                }
                $content .= '</div>';
            }
            $content .= '</div>';
        } 
    }

    // Append additional ACF fields content from display_all_acf_fields()
    if (function_exists('display_all_acf_fields')) {
        $content .= display_all_acf_fields();
    }

    $content .= "</body></html>";

    // Set headers for Word download
    header('Content-Type: application/msword');
    header('Content-Disposition: attachment; filename="' . sanitize_title(get_the_title($post)) . '.doc"');
    header('Cache-Control: max-age=0');

    // Output the content to browser
    echo $content;
    exit;
}






//////////////////////////////////////

function enqueue_popup_scripts() {
    if (is_single()) {
        // Enqueue the custom script
        wp_enqueue_script('popup-script', get_template_directory_uri() . '/assets/js/popup.js', array('jquery'), null, true);
        // Localize script for AJAX
        wp_localize_script('popup-script', 'popupAjax', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'post_id'  => get_the_ID(),
        ));
    }
}
add_action('wp_enqueue_scripts', 'enqueue_popup_scripts');


function load_post_content_ajax() {
    // Check if the post_id is provided in the AJAX request
    if (isset($_POST['post_id'])) {
        $post_id = intval($_POST['post_id']);
        $post = get_post($post_id);
        
        // Check if the post exists and is published
        if ($post && $post->post_status === 'publish') {
            
            // Include external file for API interaction (Ensure the path is correct)
            include $_SERVER['DOCUMENT_ROOT'] . '/plexity.php';
            
            global $wpdb;
            $table_name = $wpdb->prefix . 'posts';
            
            // Check if the 'gpt' column exists in the database, if not, add it
            $column_exists = $wpdb->get_results("SHOW COLUMNS FROM `$table_name` LIKE 'gpt'");
            if (empty($column_exists)) {
                // Add the 'gpt' column if it doesn't exist
                $wpdb->query("ALTER TABLE `$table_name` ADD `gpt` LONGTEXT NOT NULL");
            }

            // Retrieve the 'gpt' column value for the current post
            $gpt_content = $wpdb->get_var($wpdb->prepare(
                "SELECT gpt FROM `$table_name` WHERE ID = %d",
                $post_id
            ));

            // If 'gpt' column is not empty, return the stored response
            if (!empty($gpt_content)) {
                echo $gpt_content; // Return the stored GPT content
            } else {
                // If 'gpt' is empty, call the Perplexity API
                $apikey = "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"; // Replace with a securely stored API key
                $prompt = "Rédigez une courte resume en 5 lignes de ce contenu: " . wpautop($post->post_content);

                // Query the Perplexity API to get the response
                $messageResponse = queryPerplexityAPI($apikey, $prompt);

                // Check if the API request was successful and response is valid
                if ($messageResponse === false) {
                    echo 'API request failed. Please try again.';
                    wp_die();
                }

                // Update the 'gpt' column with the API response
                $update_result = $wpdb->update(
                    $table_name,
                    ['gpt' => $messageResponse], // The new content for the 'gpt' column
                    ['ID' => $post_id], // Target the specific post
                    ['%s'], // Format for the content
                    ['%d'] // Format for the post ID
                );

                // Check if the update was successful
                if ($update_result === false) {
                    echo 'Failed to update the post with the generated content.';
                } else {
                    // Return the API response (short description) to the frontend
                    echo $messageResponse;
                }
            }

        } else {
            echo 'Content not available.';
        }
    } else {
        echo 'Post ID is missing.';
    }

    wp_die(); // Properly end the AJAX request
}





add_action('wp_ajax_load_post_content', 'load_post_content_ajax');
add_action('wp_ajax_nopriv_load_post_content', 'load_post_content_ajax');



function add_popup_button_after_post_title($title, $id = null) {
    if (is_single() && in_the_loop() && is_main_query()) {
       // $button_html = '<a href="#" id="popup-button" class="custom-button">Afficher le résumé IA</a>';
        $popup_html = '
            <div id="popup" style="display:none; position:fixed; top:50%; left:50%; transform:translate(-50%, -50%); background:white; padding:20px; border:1px solid #ccc; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1); z-index:1000; max-width:600px; overflow-y:auto;">
                <div id="popup-content"></div>
                <button id="close-popup" style="margin-top:10px;">Close</button>
            </div>
            <div id="popup-overlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:999;"></div>
        ';
        return $title . ' ' . $button_html . $popup_html;
    }
    return $title;
}



//add_filter('the_title', 'add_popup_button_after_post_title', 10, 2);

// Step 1: Add custom user meta field to the user profile page
function add_show_button_field_to_user_profile($user) {
    ?>
    
    <table class="form-table">
        <tr>
            <th><label for="show_button"><?php _e("Afficher le résumé IA"); ?></label></th>
            <td>
                <select name="show_button" id="show_button">
                    <option value="yes" <?php echo (get_user_meta($user->ID, 'show_button', true) == 'yes') ? 'selected' : ''; ?>>Oui</option>
                    <option value="no" <?php echo (get_user_meta($user->ID, 'show_button', true) == 'no') ? 'selected' : ''; ?>>Non</option>
                </select>
            </td>
        </tr>
    </table>
<?php
}
add_action('show_user_profile', 'add_show_button_field_to_user_profile');
add_action('edit_user_profile', 'add_show_button_field_to_user_profile');

// Save the custom field value
function save_show_button_field($user_id) {
    if (isset($_POST['show_button'])) {
        update_user_meta($user_id, 'show_button', $_POST['show_button']);
    }
}
add_action('personal_options_update', 'save_show_button_field');
add_action('edit_user_profile_update', 'save_show_button_field');

// Step 2: Conditionally remove the button filter based on the user's 'show_button' setting
function conditional_add_popup_button_after_post_title($title, $post_id) {
    $user_id = get_current_user_id();
    $show_button = get_user_meta($user_id, 'show_button', true);

    // Check if the 'show_button' value is 'yes', only then add the button
    if ($show_button === 'yes') {
       add_filter('the_title', 'add_popup_button_after_post_title', 10, 2);
    }

    return $title;
}

// Only add the filter if the user has 'show_button' set to 'yes'
function add_filter_for_show_button() {
    $user_id = get_current_user_id();
    $show_button = get_user_meta($user_id, 'show_button', true);

    if ($show_button === 'yes') {
        add_filter('the_title', 'conditional_add_popup_button_after_post_title', 10, 2);
    } else {
        remove_filter('the_title', 'conditional_add_popup_button_after_post_title', 10);
        
        // Add JavaScript to hide the element with specific ID when the button is not shown
        add_action('wp_footer', function() {
            echo '<script>
                    var element = document.getElementById("popup-button");
                    if (element) {
                        element.style.display = "none";
                    }
                  </script>';
        });
    }
}

add_action('template_redirect', 'add_filter_for_show_button');



/////////////////guest//////////////////
function restrict_content_for_guests() {
    if (!is_user_logged_in() && (is_single() )) {
        wp_redirect('/plans'); // Redirect to login page
        exit;
    }
}
add_action('template_redirect', 'restrict_content_for_guests');


/////////////////////////////////////////////////////////////////////////

// Add Download Count field to user profile
function add_download_count_field($user) {
    ?>
    <h3>Statistiques de téléchargement</h3>
    <table class="form-table">
        <tr>
            <th><label for="download_count">Nombre de téléchargements</label></th>
            <td>
                <input type="number" name="download_count" value="<?php echo get_user_meta($user->ID, 'download_count', true) ?: 0; ?>" readonly />
            </td>
        </tr>
    </table>
    <?php
}
add_action('show_user_profile', 'add_download_count_field');
add_action('edit_user_profile', 'add_download_count_field');

// Function to update download count only for subscribers
function track_download_count() {
    if (is_user_logged_in()) {
        $user = wp_get_current_user();
        
        // Check if user has the 'subscriber' role
        if (in_array('subscriber', (array) $user->roles)) {
            $user_id = $user->ID;
            $count = get_user_meta($user_id, 'download_count', true) ?: 0;
            update_user_meta($user_id, 'download_count', $count + 1);
            wp_send_json_success(['count' => $count + 1]);
        } else {
            wp_send_json_error(['message' => 'Access denied: Only subscribers can download']);
        }
    } else {
        wp_send_json_error(['message' => 'User not logged in']);
    }
}
add_action('wp_ajax_track_download', 'track_download_count');


// JavaScript to track button clicks for both buttons
function download_tracking_script() {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        let buttons = ["printButton", "wordButton"];
        
        buttons.forEach(function(id) {
            let button = document.getElementById(id);
            if (button) {
                button.addEventListener("click", function() {
                    let xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo admin_url('admin-ajax.php'); ?>", true);
                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    xhr.send("action=track_download");
                });
            }
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'download_tracking_script');




///////////////////////Add buttons to post /////////////////////////////////////////

		
function register_post_buttons($content) {
	
	
    if (is_singular('post')) {
		
		        $user_id = get_current_user_id();
        $count = get_user_meta($user_id, 'download_count', true) ?: 0;
		
		if ($count <= 5) {
    $buttons =  do_shortcode('[post_buttons]'); // Corrected: removed echo
		// $button_html = '<a href="#" id="popup-button" class="custom-button">Afficher le résumé de l'IA</a>';
        $content = $count .  $buttons  . $content  ; // Prepend buttons to content
} else {
			
			       

   $content = $content  ;
}   
		
    }
    return $content;
}


add_filter('the_content', 'register_post_buttons');
 



//////////////cron//


// Schedule the event if it is not already scheduled
function custom_schedule_download_count_update() {
    if (!wp_next_scheduled('update_user_download_count_cron')) {
        wp_schedule_event(time(), 'every_two_minutes', 'update_user_download_count_cron');
    }
}
add_action('wp', 'custom_schedule_download_count_update');

// Add a custom interval of 2 minutes
function custom_cron_schedules($schedules) {
    $schedules['every_two_minutes'] = array(
        'interval' => 60, // 120 seconds = 2 minutes
        'display'  => __('Every 1 Minutes')
    );
    return $schedules;
}
add_filter('cron_schedules', 'custom_cron_schedules');

// Hook into the scheduled event
add_action('update_user_download_count_cron', 'update_download_count');

function update_download_count() {
    // Get all users
    $users = get_users(array('fields' => 'ID'));

    foreach ($users as $user_id) {
        $count = get_user_meta($user_id, 'download_count', true);
        $count = (int)$count; // Ensure it's an integer
        update_user_meta($user_id, 'download_count', 0);
    }
}

