<?php
/* Template Name: ACF Group Fields Form (Create Post with Category) */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
get_header();
?>

<div class="acf-content" style="padding: 20px;">
    <h2>Create a New Post with Custom Title, Content, ACF Group Fields, and Category</h2>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['acf_post_nonce']) || !wp_verify_nonce($_POST['acf_post_nonce'], 'acf_post_create')) {
            die('Security check failed');
        }

        $post_title    = sanitize_text_field($_POST['post_title']);
        $post_content  = wp_kses_post($_POST['post_content']);
        $post_category = intval($_POST['post_category']);
        $acf_fields    = isset($_POST['acf']) ? $_POST['acf'] : [];

        $post_id = wp_insert_post([
            'post_title'   => $post_title,
            'post_content' => $post_content,
            'post_status'  => 'publish',
            'post_author'  => get_current_user_id(),
            'post_type'    => 'post',
        ]);

        if ($post_id) {
            if ($post_category) {
                wp_set_post_categories($post_id, [$post_category]);
            }

            foreach ($acf_fields as $key => $value) {
                update_field($key, $value, $post_id);
            }

            echo '<p>✅ Post created successfully with ACF values and category!</p>';
            echo '<p><a href="' . get_permalink($post_id) . '" target="_blank">View Post</a></p>';
        } else {
            echo '<p>❌ Error creating post.</p>';
        }
    } else {
    ?>
        <form method="POST" action="">
            <?php wp_nonce_field('acf_post_create', 'acf_post_nonce'); ?>

            <label for="post_title">Post Title:</label><br>
            <input type="text" id="post_title" name="post_title" required><br><br>

            <label for="post_content">Post Content:</label><br>
            <?php
            wp_editor('', 'post_content', array(
                'textarea_name' => 'post_content',
                'textarea_rows' => 10,
                'media_buttons' => true,
            ));
            ?><br><br>

            <label for="post_category">Category:</label><br>
            <select id="post_category" name="post_category" required>
                <option value="">Select a Category</option>
                <?php
                $categories = get_categories(['orderby' => 'name', 'order' => 'ASC']);
                foreach ($categories as $category) {
                    echo '<option value="' . esc_attr($category->term_id) . '">' . esc_html($category->name) . '</option>';
                }
                ?>
            </select><br><br>

            <h3>ACF Group Fields</h3>
            <?php
            $group_key = 'group_6783007e55f17'; // Replace with your ACF group key
            $acf_fields = acf_get_fields($group_key);

            if ($acf_fields) {
                foreach ($acf_fields as $field) {
                    $field_name = $field['name'];
                    $field_label = esc_html($field['label']);
                    $field_type = $field['type'];
                    $field_choices = isset($field['choices']) ? $field['choices'] : [];

                    echo '<label>' . $field_label . ':</label><br>';

                    switch ($field_type) {
                        case 'text':
                        case 'number':
                        case 'email':
                            echo '<input type="text" name="acf[' . esc_attr($field_name) . ']" /><br><br>';
                            break;

                        case 'textarea':
                            echo '<textarea name="acf[' . esc_attr($field_name) . ']" rows="4"></textarea><br><br>';
                            break;

                        case 'select':
                            echo '<select name="acf[' . esc_attr($field_name) . ']">';
                            foreach ($field_choices as $val => $label) {
                                echo '<option value="' . esc_attr($val) . '">' . esc_html($label) . '</option>';
                            }
                            echo '</select><br><br>';
                            break;

                        case 'radio':
                            foreach ($field_choices as $val => $label) {
                                echo '<input type="radio" name="acf[' . esc_attr($field_name) . ']" value="' . esc_attr($val) . '" /> ' . esc_html($label) . '<br>';
                            }
                            echo '<br>';
                            break;

                        case 'checkbox':
                            foreach ($field_choices as $val => $label) {
                                echo '<input type="checkbox" name="acf[' . esc_attr($field_name) . '][]" value="' . esc_attr($val) . '" /> ' . esc_html($label) . '<br>';
                            }
                            echo '<br>';
                            break;

                        case 'date_picker':
                            echo '<input type="date" name="acf[' . esc_attr($field_name) . ']" /><br><br>';
                            break;

                        default:
                            echo '<input type="text" name="acf[' . esc_attr($field_name) . ']" placeholder="Unsupported field type"><br><br>';
                    }
                }
            } else {
                echo '<p>No ACF fields found in the group.</p>';
            }
            ?>

            <input type="submit" value="Create Post">
        </form>
    <?php
    }
    ?>
</div>

<?php get_footer(); ?>
