<?php
session_start();

// Include DB connection
require_once 'DB.php';

// Your Mistral API Key
$apiKey = 'FjabhwMRoLquI4bxLkGpfylVlYpxFkfc'; 

// Get the session ID (this ensures that the conversation persists across page reloads)
if (!isset($_SESSION['session_id'])) {
    $_SESSION['session_id'] = session_id(); // Use the PHP session ID for simplicity
}

// Get user message from form submission
$userMessage = trim($_POST['message'] ?? '');

// If there's a user message, insert it into the database
if ($userMessage) {
    // Insert user message into database
    $stmt = $pdo->prepare("INSERT INTO conversations (session_id, role, message) VALUES (?, ?, ?)");
    $stmt->execute([$_SESSION['session_id'], 'user', $userMessage]);
}

// Fetch all previous messages for the current session
$stmt = $pdo->prepare("SELECT role, message FROM conversations WHERE session_id = ? ORDER BY created_at ASC");
$stmt->execute([$_SESSION['session_id']]);
$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Prepare the conversation data for Mistral API
$conversation = [];
foreach ($messages as $msg) {
    $conversation[] = [
        "role" => $msg['role'],
        "content" => $msg['message']
    ];
}

// Prepare API request data
$data = [
    "model" => "mistral-small-latest",
    "messages" => $conversation
];

// Set up API headers
$headers = [
    "Authorization: Bearer $apiKey",
    "Content-Type: application/json",
    "Accept: application/json"
];

// Send API request to Mistral
$ch = curl_init("https://api.mistral.ai/v1/chat/completions");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
$response = curl_exec($ch);
curl_close($ch);

// Check if we got a valid response
if (!$response) {
    echo "No response from Mistral.";
    exit;
}

// Decode the API response
$responseData = json_decode($response, true);
$reply = $responseData['choices'][0]['message']['content'] ?? 'No reply.';

// Insert assistant's reply into database
$stmt = $pdo->prepare("INSERT INTO conversations (session_id, role, message) VALUES (?, ?, ?)");
$stmt->execute([$_SESSION['session_id'], 'assistant', $reply]);

// Return the bot's reply as plain text (Markdown-formatted)
echo $reply;
