<?php
// Set your Mistral API URL and API key
$apiUrl = 'https://api.mistral.com/v1/chat/completions';  // Update this URL as per the Mistral API documentation
$apiKey = 'rdQqiv7mxo11hrJm4f27OrA2gn5u1UKA';  // Replace with your Mistral API key

// Get message and session_id from the POST request
$message = isset($_POST['message']) ? $_POST['message'] : '';
$sessionId = isset($_POST['session_id']) ? $_POST['session_id'] : '';

// Check if the message is empty
if (empty($message)) {
    echo json_encode(['bot_response' => 'No message provided.']);
    exit;
}

// Prepare the data for the API request
$data = [
    'model' => 'mistral-model-v1',  // Update this as per Mistral's model version
    'messages' => [
        ['role' => 'user', 'content' => $message]
    ],
    'session_id' => $sessionId
];

// Initialize cURL
$ch = curl_init($apiUrl);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $apiKey
]);

// Execute cURL request and get response
$response = curl_exec($ch);

// Check for errors
if(curl_errno($ch)) {
    echo json_encode(['bot_response' => 'Error communicating with the API: ' . curl_error($ch)]);
} else {
    // Decode JSON response from Mistral API
    $responseData = json_decode($response, true);
    if (isset($responseData['choices'][0]['message']['content'])) {
        $botResponse = $responseData['choices'][0]['message']['content'];
        echo json_encode(['bot_response' => $botResponse]);
    } else {
        echo json_encode(['bot_response' => 'No valid response received from the API.']);
    }
}

// Close cURL session
curl_close($ch);
?>
