<?php
require_once 'DB.php';

header('Content-Type: application/json');

// Get the action from the request
$action = $_GET['action'] ?? $_POST['action'] ?? '';

try {
    switch ($action) {
        case 'get':
            // Get all prompts
            $stmt = $pdo->query("SELECT * FROM prompts WHERE is_deleted = FALSE ORDER BY category, title");
            $prompts = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($prompts);
            break;
            
        case 'get_single':
            // Get a single prompt by ID
            $id = $_GET['id'] ?? 0;
            $stmt = $pdo->prepare("SELECT * FROM prompts WHERE id = ? AND is_deleted = FALSE");
            $stmt->execute([$id]);
            $prompt = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($prompt) {
                echo json_encode($prompt);
            } else {
                echo json_encode(['error' => 'Prompt not found']);
            }
            break;
            
        case 'get_categories':
            // Get all unique categories
            $stmt = $pdo->query("SELECT DISTINCT category FROM prompts WHERE is_deleted = FALSE ORDER BY category");
            $categories = $stmt->fetchAll(PDO::FETCH_COLUMN);
            echo json_encode($categories);
            break;
            
        case 'create':
            // Create a new prompt
            $title = $_POST['title'] ?? '';
            $category = $_POST['category'] ?? '';
            $content = $_POST['content'] ?? '';
            
            if (empty($title) || empty($category) || empty($content)) {
                echo json_encode(['success' => false, 'error' => 'All fields are required']);
                break;
            }
            
            $stmt = $pdo->prepare("INSERT INTO prompts (title, category, content) VALUES (?, ?, ?)");
            $stmt->execute([$title, $category, $content]);
            echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
            break;
            
        case 'update':
            // Update an existing prompt
            $id = $_POST['id'] ?? 0;
            $title = $_POST['title'] ?? '';
            $category = $_POST['category'] ?? '';
            $content = $_POST['content'] ?? '';
            
            if (empty($id) || empty($title) || empty($category) || empty($content)) {
                echo json_encode(['success' => false, 'error' => 'All fields are required']);
                break;
            }
            
            $stmt = $pdo->prepare("UPDATE prompts SET title = ?, category = ?, content = ? WHERE id = ?");
            $stmt->execute([$title, $category, $content, $id]);
            echo json_encode(['success' => true]);
            break;
            
        case 'delete':
            // Delete a prompt (soft delete)
            $id = $_GET['id'] ?? 0;
            $stmt = $pdo->prepare("UPDATE prompts SET is_deleted = TRUE WHERE id = ?");
            $stmt->execute([$id]);
            echo json_encode(['success' => true]);
            break;
            
        default:
            echo json_encode(['error' => 'Invalid action']);
            break;
    }
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>