<?php
require_once 'DB.php';

header('Content-Type: application/json');

$title = $_POST['title'] ?? '';
$category = $_POST['category'] ?? '';
$content = $_POST['content'] ?? '';

if (empty($title) || empty($category) || empty($content)) {
    echo json_encode(['success' => false, 'error' => 'All fields are required']);
    exit;
}

try {
    $stmt = $pdo->prepare("INSERT INTO prompts (title, category, content) VALUES (?, ?, ?)");
    $stmt->execute([$title, $category, $content]);
    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>