<?php
require_once 'DB.php';

header('Content-Type: application/json');

$id = $_POST['id'] ?? 0;
$title = $_POST['title'] ?? '';
$category = $_POST['category'] ?? '';
$content = $_POST['content'] ?? '';

if (empty($id) || empty($title) || empty($category) || empty($content)) {
    echo json_encode(['success' => false, 'error' => 'All fields are required']);
    exit;
}

try {
    $stmt = $pdo->prepare("UPDATE prompts SET title = ?, category = ?, content = ? WHERE id = ?");
    $stmt->execute([$title, $category, $content, $id]);
    echo json_encode(['success' => true]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>