<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Document Assistant</title>
    <link rel="stylesheet" href="style.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/pdfjs-dist@3.4.120/build/pdf.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/showdown/dist/showdown.min.js"></script>

</head>

<body>
    <?php include 'side.php'; ?>

    <div class="container">
        <h1><i class="fas fa-robot"></i> AI Document Assistant</h1>

        <div class="tabs">
            <button class="tab active" onclick="openTab(event, 'chat')"><i class="fas fa-comments"></i> Chat</button>
            <button class="tab" onclick="openTab(event, 'settings')"><i class="fas fa-cog"></i> Settings</button>
        </div>

        <div id="chat" class="tab-content active">
            <div class="chat-container">
                <div id="chat-box">
                    <div class="message bot-message">
                        <div class="message-content">
                            <p>Hello! I'm your AI Document Assistant. You can:</p>
                            <ul>
                                <li>Ask me questions about your documents</li>
                                <li>Upload PDF or DOCX files for analysis</li>
                                <li>Get summaries or explanations</li>
                            </ul>
                            <p>How can I help you today?</p>
                        </div>
                        <div class="message-time">Just now</div>
                        <div class="message-actions">
                            <button class="btn btn-sm btn-outline" onclick="copyMessage(this)"><i class="fas fa-copy"></i></button>
                        </div>
                    </div>
                </div>
                <div class="box-chats" style="    padding: 1rem;border-top: 1px solid #e5e7eb;display: flex;align-content: center;align-items: center;gap: 16px;">
                                    <div>
                    <button id="upload-btn" class="btn btn-outline"><i class="fas fa-paperclip" style="margin:0px !important" ></i></button>
                    <input type="file" id="pdf-upload" accept=".pdf,.docx" hidden>
                </div>
                    
                    <textarea id="user-input" placeholder="Type your message here..." style="flex: 1; resize: vertical;" rows="3"></textarea>
                    <button class="btn" onclick="sendMessage()"><i class="fas fa-paper-plane"></i> Send</button>
                    
                </div>
                
                                <div id="file-preview" style="display: none;">
                    <div class="file-info">
                        <i class="fas fa-file-alt"></i>
                        <div class="file-details">
                            <div class="file-name" id="file-name"></div>
                            <div class="file-size" id="file-size"></div>
                        </div>
                        <button class="btn btn-sm btn-outline" onclick="clearFile()"><i class="fas fa-times"></i></button>
                    </div>
                </div>
            </div>


        </div>

        <div id="settings" class="tab-content">
            <div class="card api-key-section">
                <div class="card-header">
                    <div class="card-title"><i class="fas fa-key"></i> API Configuration</div>
                </div>
                <div class="input-group">
                    <label for="api-key">Mistral AI API Key</label>
                    <div>
                        <input type="password" id="api-key" placeholder="Enter your Mistral AI API key" style="flex: 1;">
                        <button class="btn" onclick="saveApiKey()"><i class="fas fa-save"></i> Save</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p>Processing document with AI...</p>
            <div class="progress-bar">
                <div class="progress" id="progress-bar"></div>
            </div>
        </div>

        <div class="toast" id="toast"></div>
    </div>





<script>
  // Public containers
  let shortcodeCont = null;
  let contentCont = null;

  function insertPromptIntoChat(promptData) {
      // Save to public variables
      shortcodeCont = promptData.short_code;
      contentCont = promptData.content;

      let insertText = '';

      // Convert short_code to string if it's an object
      if (shortcodeCont && typeof shortcodeCont === 'object') {
          insertText = JSON.stringify(shortcodeCont, null, 2); // Pretty print
      } else {
          insertText = String(shortcodeCont);
      }

      const input = document.getElementById('user-input');
      if (!input) return;

      const currentValue = input.value;
      const selectionStart = input.selectionStart;
      const selectionEnd = input.selectionEnd;

      // Insert the short_code text
      input.value = currentValue.substring(0, selectionStart) +
                    insertText +
                    currentValue.substring(selectionEnd);

      input.focus();
      input.setSelectionRange(selectionStart + insertText.length, selectionStart + insertText.length);
  }

  // Example: you can access contentCont anywhere later
   // console.log(shortcodeCont, contentCont);
</script>










    <script>
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdn.jsdelivr.net/npm/pdfjs-dist@3.4.120/build/pdf.worker.min.js';
        const converter = new showdown.Converter();

        // DOM elements
        const chatBox = document.getElementById("chat-box");
        const userInput = document.getElementById("user-input");
        const apiKeyInput = document.getElementById('api-key');
        const uploadBtn = document.getElementById('upload-btn');
        const fileInput = document.getElementById('pdf-upload');
        const filePreview = document.getElementById('file-preview');
        const fileNameDisplay = document.getElementById('file-name');
        const fileSizeDisplay = document.getElementById('file-size');
        const loadingIndicator = document.getElementById('loading');
        const progressBar = document.getElementById('progress-bar');
        const toast = document.getElementById('toast');

        // State variables
        let conversationHistory = [];
        let botMessageElement = null;
        let uploadedFile = null;
        let isTyping = false;

        // Initialize the app
        document.addEventListener('DOMContentLoaded', () => {
            // Load saved API key from local storage
            const savedApiKey = localStorage.getItem('mistralApiKey');
            if (savedApiKey) {
                apiKeyInput.value = savedApiKey;
            }

            // Set up event listeners
            setupEventListeners();
        });

        function openTab(evt, tabName) {
            // Declare all variables
            let i, tabcontent, tablinks;

            // Get all elements with class="tab-content" and hide them
            tabcontent = document.getElementsByClassName("tab-content");
            for (i = 0; i < tabcontent.length; i++) {
                tabcontent[i].classList.remove("active");
            }

            // Get all elements with class="tab" and remove the class "active"
            tablinks = document.getElementsByClassName("tab");
            for (i = 0; i < tablinks.length; i++) {
                tablinks[i].classList.remove("active");
            }

            // Show the current tab, and add an "active" class to the button that opened the tab
            document.getElementById(tabName).classList.add("active");
            evt.currentTarget.classList.add("active");
        }

        function setupEventListeners() {
            // File upload handling
            uploadBtn.addEventListener('click', () => fileInput.click());
            fileInput.addEventListener('change', (e) => handleFiles(e.target.files));
        }

        function handleKeyPress(event) {
            if (event.key === 'Enter' && !event.shiftKey) {
                event.preventDefault();
                sendMessage();
            }
        }

        function saveApiKey() {
            const apiKey = apiKeyInput.value.trim();
            if (apiKey) {
                localStorage.setItem('mistralApiKey', apiKey);
                showToast('API Key saved successfully!');
            } else {
                showToast('Please enter an API Key to save.', 'error');
            }
        }

        function handleFiles(files) {
            if (files.length > 0) {
                uploadedFile = files[0];
                updateFilePreview(uploadedFile);
                addMessage(`Uploaded file: ${uploadedFile.name}`, "user");
            }
        }

        function updateFilePreview(file) {
            fileNameDisplay.textContent = file.name;
            fileSizeDisplay.textContent = formatFileSize(file.size);
            filePreview.style.display = 'block';
        }

        function clearFile() {
            uploadedFile = null;
            fileInput.value = '';
            filePreview.style.display = 'none';
        }

        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }

        function addMessage(text, sender) {
            const messageDiv = document.createElement("div");
            messageDiv.className = `message ${sender}-message`;

            const contentDiv = document.createElement("div");
            contentDiv.className = "message-content";

            if (sender === "bot") {
                contentDiv.innerHTML = converter.makeHtml(text);
                // Add copy button only for bot messages
                const actionsDiv = document.createElement("div");
                actionsDiv.className = "message-actions";
                actionsDiv.innerHTML = `<button class="btn btn-sm btn-outline" onclick="copyMessage(this)"><i class="fas fa-copy"></i></button>`;
                messageDiv.appendChild(actionsDiv);
            } else {
                contentDiv.textContent = text;
            }

            messageDiv.appendChild(contentDiv);

            const timeDiv = document.createElement("div");
            timeDiv.className = "message-time";
            timeDiv.textContent = getCurrentTime();
            messageDiv.appendChild(timeDiv);

            chatBox.appendChild(messageDiv);
            chatBox.scrollTop = chatBox.scrollHeight;

            return messageDiv;
        }

        function showTypingIndicator() {
            if (isTyping) return;

            isTyping = true;
            const typingDiv = document.createElement("div");
            typingDiv.className = "message bot-message";

            const contentDiv = document.createElement("div");
            contentDiv.className = "typing-indicator";
            contentDiv.innerHTML = `
                <div class="typing-dot"></div>
                <div class="typing-dot"></div>
                <div class="typing-dot"></div>
            `;

            typingDiv.appendChild(contentDiv);
            chatBox.appendChild(typingDiv);
            chatBox.scrollTop = chatBox.scrollHeight;

            return typingDiv;
        }

        function removeTypingIndicator(typingElement) {
            if (typingElement && typingElement.parentNode) {
                chatBox.removeChild(typingElement);
            }
            isTyping = false;
        }

        function getCurrentTime() {
            const now = new Date();
            return now.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
        }

        function copyMessage(button) {
            const messageContent = button.closest('.message').querySelector('.message-content');
            const range = document.createRange();
            range.selectNode(messageContent);
            window.getSelection().removeAllRanges();
            window.getSelection().addRange(range);
            document.execCommand('copy');
            window.getSelection().removeAllRanges();

            showToast('Message copied to clipboard!');
        }

        function showToast(message, type = 'success') {
            toast.textContent = message;
            toast.className = `toast ${type}`;
            toast.classList.add('show');

            setTimeout(() => {
                toast.classList.remove('show');
            }, 3000);
        }

        async function uploadFileToMistral(apiKey, file) {
            const formData = new FormData();
            formData.append('purpose', 'ocr');
            formData.append('file', file);

            try {
                const uploadResponse = await fetch('https://api.mistral.ai/v1/files', {
                    method: 'POST',
                    headers: {
                        'Authorization': `Bearer ${apiKey}`
                    },
                    body: formData
                });

                if (!uploadResponse.ok) {
                    let errorMessage;
                    try {
                        const errorData = await uploadResponse.json();
                        errorMessage = errorData.error?.message || uploadResponse.statusText;
                    } catch (e) {
                        errorMessage = `Status ${uploadResponse.status}: ${uploadResponse.statusText}`;
                    }
                    throw new Error(`File upload failed: ${errorMessage}`);
                }

                return await uploadResponse.json();
            } catch (error) {
                console.error('Upload error:', error);
                throw error;
            }
        }






        async function processFileWithOcr(apiKey, file) {
            try {
                // Show loading indicator with progress animation
                loadingIndicator.classList.add('active');
                let progress = 0;
                const progressInterval = setInterval(() => {
                    progress = Math.min(progress + 5, 90);
                    progressBar.style.width = `${progress}%`;
                }, 300);

                const fileData = await uploadFileToMistral(apiKey, file);
                const fileId = fileData.id;

                const urlResponse = await fetch(`https://api.mistral.ai/v1/files/${fileId}/url?expiry=24`, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'Authorization': `Bearer ${apiKey}`
                    }
                });

                if (!urlResponse.ok) {
                    throw new Error(`Failed to get signed URL: ${urlResponse.status}`);
                }

                const urlData = await urlResponse.json();
                const signedUrl = urlData.url;

                const ocrResponse = await fetch('https://api.mistral.ai/v1/ocr', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': `Bearer ${apiKey}`
                    },
                    body: JSON.stringify({
                        model: "mistral-ocr-latest",
                        document: {
                            type: "document_url",
                            document_url: signedUrl
                        }
                    })
                });

                if (!ocrResponse.ok) {
                    let errorDetail;
                    try {
                        const errorData = await ocrResponse.json();
                        errorDetail = JSON.stringify(errorData);
                    } catch (e) {
                        errorDetail = `Status ${ocrResponse.status}: ${ocrResponse.statusText}`;
                    }
                    throw new Error(`OCR processing failed: ${errorDetail}`);
                }

                clearInterval(progressInterval);
                progressBar.style.width = '100%';
                setTimeout(() => {
                    loadingIndicator.classList.remove('active');
                    progressBar.style.width = '0';
                }, 500);

                return await ocrResponse.json();
            } catch (error) {
                console.error('Error in OCR process:', error);
                loadingIndicator.classList.remove('active');
                progressBar.style.width = '0';
                throw error;
            }
        }

        function displayOcrResults(result) {
            let markdownText = '';

            if (result.markdown) {
                markdownText = result.markdown;
            } else if (result.text) {
                markdownText = result.text;
            } else if (result.content) {
                markdownText = result.content;
            } else if (result.pages && Array.isArray(result.pages)) {
                markdownText = result.pages
                    .filter(page => page !== undefined)
                    .map(page => page.markdown || page.text || page.content || '')
                    .join('\n\n');
            }

            if (markdownText) {
                return converter.makeHtml(markdownText);
            } else {
                return '<p>No text content available in the response</p>';
            }
        }





        async function sendMessage() {
         
              const prompts = userInput.value.trim();
            const prompt = userInput.value.trim().replace(shortcodeCont, contentCont);

          console.log(prompt);
            const file = uploadedFile;
            const apiKey = apiKeyInput.value.trim();

            if (!prompt && !file) {
                showToast('Please enter a message or upload a file', 'error');
                return;
            }

            if (prompt) {
                addMessage(prompts, "user");
                userInput.value = "";
            }

            if (file) {
                uploadedFile = null;
                clearFile();
            }

            const typingElement = showTypingIndicator();

            try {
                if (file) {
                    if (!apiKey) {
                        throw new Error('Please enter your Mistral AI API key');
                    }

                    const result = await processFileWithOcr(apiKey, file);
                    const ocrText = displayOcrResults(result);

                    removeTypingIndicator(typingElement);
                    botMessageElement = addMessage(ocrText, "bot");
                    conversationHistory.push({ role: "user", content: `File content: ${ocrText}` });
                }

                if (prompt) {
                    conversationHistory.push({ role: "user", content: prompt });
                }

                const res = await fetch("https://openrouter.ai/api/v1/chat/completions", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "Authorization": "Bearer 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"
                    },
                    body: JSON.stringify({
                        model: "deepseek/deepseek-chat",
                        temperature: 0.6,
                        stream: true,
                        messages: conversationHistory
                    })
                });

                removeTypingIndicator(typingElement);

                const reader = res.body.getReader();
                const decoder = new TextDecoder("utf-8");
                let result = "";
                botMessageElement = addMessage("", "bot");

                while (true) {
                    const { done, value } = await reader.read();
                    if (done) break;

                    const lines = decoder.decode(value).split("\n");
                    for (const line of lines) {
                        if (line.startsWith("data:")) {
                            try {
                                const data = JSON.parse(line.replace("data: ", ""));
                                const text = data.choices?.[0]?.delta?.content || "";
                                result += text;
                                botMessageElement.querySelector('.message-content').innerHTML = converter.makeHtml(result);
                                chatBox.scrollTop = chatBox.scrollHeight;
                            } catch (e) {
                                console.error('Error parsing stream data:', e);
                            }
                        }
                    }
                }

                conversationHistory.push({ role: "assistant", content: result });

            } catch (err) {
                console.error('Error:', err);
                removeTypingIndicator(typingElement);
                addMessage(`❌ Error: ${err.message}`, "bot");
                showToast(err.message, 'error');
            }
        }

        // Add event listener for the textarea to handle Enter key
        document.getElementById('user-input').addEventListener('keydown', handleKeyPress);
    </script>
  

  
</body>
</html>
