<?php
session_start();
require 'db_config.php';

if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION["user_id"];

$stmt = $conn->prepare("SELECT username, email FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($username, $email);
$stmt->fetch();
?>

<!DOCTYPE html>
<html>
<head>
    <title>User Profile</title>
</head>
<body>
<h2>Welcome, <?php echo htmlspecialchars($username); ?>!</h2>
<p>Email: <?php echo htmlspecialchars($email); ?></p>
<a href="logout.php">Logout</a>
</body>
</html>
