<?php
require 'config.php'; // Ensure this file contains your database connection details

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'save':
        saveApiKeys();
        break;
    case 'get':
        getApiKeys();
        break;
    default:
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
        break;
}

function saveApiKeys() {
    global $pdo;

    $projectId = $_POST['project_id'] ?? 0;
    $mistralApiKey = $_POST['mistral_api_key'] ?? '';
    $openrouterApiKey = $_POST['openrouter_api_key'] ?? '';

    if (empty($mistralApiKey) && empty($openrouterApiKey)) {
        echo json_encode(['success' => false, 'message' => 'At least one API key is required']);
        return;
    }

    try {
        $stmt = $pdo->prepare("REPLACE INTO api_keys (project_id, api_key, openrouter_api_key) VALUES (:project_id, :mistral_api_key, :openrouter_api_key)");
        $stmt->execute([
            'project_id' => $projectId,
            'mistral_api_key' => $mistralApiKey,
            'openrouter_api_key' => $openrouterApiKey
        ]);
        echo json_encode(['success' => true, 'message' => 'API keys saved successfully']);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}

function getApiKeys() {
    global $pdo;

    $projectId = $_POST['project_id'] ?? 0;

    try {
        $stmt = $pdo->prepare("SELECT api_key, openrouter_api_key FROM api_keys WHERE project_id = :project_id");
        $stmt->execute(['project_id' => $projectId]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            echo json_encode([
                'success' => true,
                'mistral_api_key' => $result['api_key'],
                'openrouter_api_key' => $result['openrouter_api_key']
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'API keys not found']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>
