<?php
require 'config.php';

if (!isset($_SESSION['user'])) {
    header("HTTP/1.1 401 Unauthorized");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (isset($data['role']) && isset($data['content'])) {
        if (!isset($_SESSION['chat_history'])) {
            $_SESSION['chat_history'] = [];
        }
        
        // Store the content as-is (already in HTML format)
        $_SESSION['chat_history'][] = [
            'role' => $data['role'],
            'content' => $data['content']
        ];
        
        header("HTTP/1.1 200 OK");
        echo json_encode(['success' => true]);
    } else {
        header("HTTP/1.1 400 Bad Request");
        echo json_encode(['error' => 'Invalid data']);
    }
} else {
    header("HTTP/1.1 405 Method Not Allowed");
    echo json_encode(['error' => 'Method not allowed']);
}
?>