<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat IA en Direct</title>
    <script src="https://cdn.jsdelivr.net/npm/showdown/dist/showdown.min.js"></script>
    <script>
        // Initialize Showdown converter
        const converter = new showdown.Converter();

        async function callOpenRouterAPI() {
            const apiKey = "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"; // Votre clé API
            const prompt = document.getElementById("prompt").value.trim();
            const responseElement = document.getElementById("response");
            const responseTimeElement = document.getElementById("responseTime");

            if (!prompt) {
                responseElement.innerHTML = "⚠️ Veuillez entrer une invite.";
                return;
            }

            // Get the selected model
            const selectedModel = document.querySelector('input[name="model"]:checked').value;

            const url = "https://openrouter.ai/api/v1/chat/completions";
            const data = {
                temperature: 0.6, // Réglé à 0.6 pour améliorer la précision
                truncate: true, // Réponse tronquée si elle dépasse la limite
                model: selectedModel, // Use selected model
                messages: [{ role: "user", content: prompt }],
                stream: true // Activation du streaming en temps réel
            };

            responseElement.innerHTML = "⏳ Génération de la réponse...";
            responseTimeElement.innerText = "";

            const startTime = performance.now();

            try {
                const response = await fetch(url, {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "Authorization": `Bearer ${apiKey}`
                    },
                    body: JSON.stringify(data)
                });

                if (!response.body) throw new Error("Pas de corps de réponse");

                const endTime = performance.now();
                const elapsedTime = ((endTime - startTime) / 1000).toFixed(2);
                responseTimeElement.innerText = `⏱️ Temps de réponse : ${elapsedTime} secondes`;

                const reader = response.body.getReader();
                const decoder = new TextDecoder("utf-8");
                let finalText = "";
                let firstChunkReceived = false;

                responseElement.innerHTML = ""; // Effacer le contenu précédent

                while (true) {
                    const { done, value } = await reader.read();
                    if (done) break;
                    const chunk = decoder.decode(value, { stream: true });

                    const lines = chunk.split("\n").filter(line => line.trim() !== "");
                    for (const line of lines) {
                        if (line.startsWith("data:")) {
                            try {
                                const jsonData = JSON.parse(line.replace("data: ", ""));
                                const textPart = jsonData.choices?.[0]?.delta?.content || "";
                                finalText += textPart;

                                // Hide the loading message once the first chunk of text arrives
                                if (!firstChunkReceived && finalText.trim().length > 0) {
                                    responseElement.innerHTML = converter.makeHtml(finalText);
                                    firstChunkReceived = true; // First chunk received, hide loading message
                                } else {
                                    responseElement.innerHTML = converter.makeHtml(finalText); // Continue displaying the text
                                }
                            } catch (error) {
                                console.warn("Erreur de streaming :", error);
                            }
                        }
                    }
                }
            } catch (error) {
                responseElement.innerHTML = "❌ Erreur lors de la récupération de la réponse.";
                console.error("Erreur :", error);
            }
        }

        // Sauvegarder l'invite dans localStorage
        function savePrompt() {
            const prompt = document.getElementById("prompt").value.trim();
            if (prompt) {
                localStorage.setItem("savedPrompt", prompt);
                alert("Invite sauvegardée avec succès !");
            }
        }

        // Réinitialiser l'invite et supprimer les données sauvegardées
        function resetPrompt() {
            document.getElementById("prompt").value = ""; // Effacer la zone de texte
            localStorage.removeItem("savedPrompt"); // Supprimer l'invite sauvegardée du localStorage
        }

        // Charger l'invite sauvegardée au chargement de la page
        window.onload = function() {
            const savedPrompt = localStorage.getItem("savedPrompt");
            if (savedPrompt) {
                document.getElementById("prompt").value = savedPrompt;
            }
        };

        // Copier le texte dans le presse-papiers
        function copyToClipboard() {
            const responseText = document.getElementById("response").innerText;
            if (responseText) {
                navigator.clipboard.writeText(responseText).then(() => {
                    alert("Réponse copiée dans le presse-papiers !");
                }).catch(err => {
                    alert("Erreur lors de la copie : " + err);
                });
            }
        }
    </script>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            max-width: 900px;
            line-height: 1.6;
            background-color: #f9f9f9;
            color: #333;
        }
        h1 {
            font-size: 24px;
            color: #007BFF;
        }
        textarea {
            width: 100%;
            margin-bottom: 10px;
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
            background-color: #fff;
        }
        button {
            padding: 12px 20px;
            font-size: 16px;
            cursor: pointer;
            transition: 0.3s;
            margin-top: 10px;
            border-radius: 5px;
        }
        .save-btn, .reset-btn, .copy-btn {
            padding: 8px 15px;
            font-size: 14px;
            margin-right: 10px;
        }
        .save-btn {
            background-color: #28a745; /* Vert */
            color: white;
            border: none;
        }
        .copy-btn {
            background-color: #17a2b8; /* Bleu clair */
            color: white;
            border: none;
        }
        .save-btn:hover, .copy-btn:hover {
            opacity: 0.8;
        }
        .reset-btn {
            background-color: #dc3545; /* Rouge */
            color: white;
            border: none;
        }
        .reset-btn:hover {
            background-color: #c82333;
        }
        .send-btn {
            background-color: #007BFF; /* Bleu */
            color: white;
            width: 100%;
            border: none;
        }
        .send-btn:hover {
            background-color: #0056b3;
        }
        #response {
            margin-top: 20px;
            padding: 15px;
            background: #fff;
            border-radius: 5px;
            min-height: 50px;
            border: 1px solid #ddd;
            box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1);
            transition: background-color 0.3s ease;
        }
        #responseTime {
            font-weight: bold;
            margin-top: 10px;
            color: green;
        }
        .buttons-container {
            display: flex;
            justify-content: flex-end;
        }

        .copy-btn:hover {
            background-color: #138496;
        }
        .copy-btn svg {
            fill: currentColor;
        }
        .icon-xs {
            width: 16px;
            height: 16px;
        }
        #response {
            position: relative;
        }
    </style>
</head>
<body>
    <h1>Guilaw Chat IA</h1>

    <label for="prompt">Invite :</label>
    <textarea id="prompt" rows="5" placeholder="Entrez votre invite ici..."></textarea>

    <div>
        <label>Choisissez le modèle :</label>
        <div>
            <label>
                <input type="radio" name="model" value="deepseek/deepseek-chat" checked>
                Rapide
            </label>
            <label>
                <input type="radio" name="model" value="deepseek/deepseek-r1-distill-qwen-32b">
                Long
            </label>
        </div>
    </div>

    <div class="buttons-container">
        <button class="save-btn" onclick="savePrompt()">Sauvegarder l'invite</button>
        <button class="reset-btn" onclick="resetPrompt()">Réinitialiser l'invite</button>
    </div>

    <button class="send-btn" onclick="callOpenRouterAPI()">Envoyer la demande</button>

    <h2>Réponse :</h2>
    <button class="copy-btn save-btn" onclick="copyToClipboard()" aria-label="Copier">
        <svg width="12" height="12" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-xs">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M7 5C7 3.34315 8.34315 2 10 2H19C20.6569 2 22 3.34315 22 5V14C22 15.6569 20.6569 17 19 17H17V19C17 20.6569 15.6569 22 14 22H5C3.34315 22 2 20.6569 2 19V10C2 8.34315 3.34315 7 5 7H7V5ZM9 7H14C15.6569 7 17 8.34315 17 10V15H19C19.5523 15 20 14.5523 20 14V5C20 4.44772 19.5523 4 19 4H10C9.44772 4 9 4.44772 9 5V7ZM5 9C4.44772 9 4 9.44772 4 10V19C4 19.5523 4.44772 20 5 20H14C14.5523 20 15 19.5523 15 19V17H7V15H5V9Z"/>
        </svg>
        Copier
    </button>
    <div id="response"></div>
    <div id="responseTime"></div>
</body>
</html>
