<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Chat IA - DeepSeek</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.jsdelivr.net/npm/showdown/dist/showdown.min.js"></script>
  <style>
    body {
      font-family: sans-serif;
      max-width: 700px;
      margin: 30px auto;
      background: #f9f9f9;
      padding: 20px;
    }
    h1 { color: #007bff; }
    textarea, button {
      width: 100%;
      font-size: 16px;
      padding: 10px;
      margin-top: 10px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    button {
      background: #007bff;
      color: white;
      cursor: pointer;
      border: none;
    }
    #response {
      background: #fff;
      padding: 15px;
      margin-top: 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      white-space: pre-wrap;
    }
    .copy {
      background: #28a745;
      margin-top: 5px;
    }
  </style>
</head>
<body>
  <h1>Chat IA - DeepSeek</h1>
  <textarea id="prompt" rows="5" placeholder="Posez votre question..."></textarea>
  <button onclick="sendPrompt()">Envoyer</button>

  <div id="response"></div>
  <button class="copy" onclick="copyResponse()">📋 Copier la réponse</button>

  <script>
    const converter = new showdown.Converter();

    async function sendPrompt() {
      const prompt = document.getElementById("prompt").value.trim();
      const output = document.getElementById("response");
      if (!prompt) return alert("Entrez un message.");
      output.innerHTML = "⏳ Réponse en cours...";

      try {
        const res = await fetch("https://openrouter.ai/api/v1/chat/completions", {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            "Authorization": "Bearer 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"
          },
          body: JSON.stringify({
            model: "deepseek/deepseek-chat",
            temperature: 0.6,
            stream: true,
            messages: [{ role: "user", content: prompt }]
          })
        });

        const reader = res.body.getReader();
        const decoder = new TextDecoder("utf-8");
        let result = "";

        while (true) {
          const { done, value } = await reader.read();
          if (done) break;
          const lines = decoder.decode(value).split("\n");

          for (const line of lines) {
            if (line.startsWith("data:")) {
              try {
                const data = JSON.parse(line.replace("data: ", ""));
                const text = data.choices?.[0]?.delta?.content || "";
                result += text;
                output.innerHTML = converter.makeHtml(result);
              } catch {}
            }
          }
        }
      } catch {
        output.innerHTML = "❌ Une erreur s’est produite.";
      }
    }

    function copyResponse() {
      const text = document.getElementById("response").innerText;
      navigator.clipboard.writeText(text).then(() => alert("Réponse copiée !"));
    }
  </script>
</body>
</html>
