<?php
require 'config.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Dashboard</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f0f2f5;
        padding: 2rem;
        color: #333;
    }
    .container {
        max-width: 600px;
        margin: auto;
        background: white;
        padding: 2rem;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        text-align: center;
    }
    h1 {
        margin-bottom: 0.5rem;
    }
    .role {
        font-weight: bold;
        margin-bottom: 1.5rem;
        color: #555;
    }
    a.button {
        text-decoration: none;
        background: #007bff;
        color: white;
        padding: 0.75rem 1.5rem;
        border-radius: 6px;
        font-weight: 600;
        margin: 0 0.5rem;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: background-color 0.3s ease;
    }
    a.button:hover {
        background: #0056b3;
    }
</style>
</head>
<body>
    <div class="container">
        <h1>Welcome, <?php echo htmlspecialchars($_SESSION['user']['username']); ?>!</h1>
        <div class="role">Role: <?php echo $_SESSION['user']['role']; ?></div>

        <?php if ($_SESSION['user']['role'] === 'admin'): ?>
            <a href="admin.php" class="button"><i class="fa-solid fa-user-shield"></i> Admin Panel</a>
        <?php endif; ?>

        <a href="logout.php" class="button"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
    </div>
</body>
</html>
