<?php
require 'config.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    echo "Access denied.";
    exit;
}

// Handle user creation
if (isset($_POST['create'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $role = $_POST['role'];

    if ($username && $password && in_array($role, ['admin', 'user'])) {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetch()) {
            $msg = "Username already exists.";
        } else {
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $stmtInsert = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
            $stmtInsert->execute([$username, $hashedPassword, $role]);
            $msg = "User created successfully.";
        }
    } else {
        $msg = "Please fill all fields correctly.";
    }
}

// Handle user deletion
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    if ($id !== $_SESSION['user']['id']) {
        $pdo->prepare("DELETE FROM users WHERE id = ?")->execute([$id]);
        $msg = "User deleted.";
    }
}

// Handle user update
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $username = $_POST['username'];
    $password = $_POST['password'];
    $role = $_POST['role'];

    if ($password) {
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
        $pdo->prepare("UPDATE users SET username = ?, password = ?, role = ? WHERE id = ?")
            ->execute([$username, $hashedPassword, $role, $id]);
    } else {
        $pdo->prepare("UPDATE users SET username = ?, role = ? WHERE id = ?")
            ->execute([$username, $role, $id]);
    }
    $msg = "User updated.";
}

// Fetch all users
$users = $pdo->query("SELECT * FROM users ORDER BY id ASC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Admin Panel</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f9fafb;
        padding: 2rem;
    }
    .container {
        max-width: 1000px;
        margin: auto;
        background: white;
        padding: 2rem;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.08);
    }
    h2 {
        text-align: center;
        margin-bottom: 2rem;
    }
    form input, form select, form button {
        padding: 0.5rem;
        margin: 0.25rem;
        border-radius: 5px;
        border: 1px solid #ccc;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 2rem;
    }
    table, th, td {
        border: 1px solid #ccc;
    }
    th, td {
        padding: 0.75rem;
        text-align: left;
    }
    .actions form {
        display: inline;
    }
    .msg {
        margin: 1rem 0;
        font-weight: bold;
        color: green;
    }
</style>
</head>
<body>
<div class="container">
    <h2><i class="fa-solid fa-user-shield"></i> Admin Panel</h2>

    <?php if (!empty($msg)): ?>
        <p class="msg"><?php echo $msg; ?></p>
    <?php endif; ?>

    <h3>Create User</h3>
    <form method="POST">
        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>
        <select name="role" required>
            <option value="user">User</option>
            <option value="admin">Admin</option>
        </select>
        <button type="submit" name="create"><i class="fa fa-user-plus"></i> Create</button>
    </form>

    <h3>Manage Users</h3>
    <table>
        <thead>
            <tr>
                <th>ID</th><th>Username</th><th>Role</th><th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <form method="POST">
                        <td><?php echo $user['id']; ?></td>
                        <td>
                            <input type="text" name="username" value="<?php echo htmlspecialchars($user['username']); ?>">
                        </td>
                        <td>
                            <select name="role">
                                <option value="user" <?php if ($user['role'] == 'user') echo 'selected'; ?>>User</option>
                                <option value="admin" <?php if ($user['role'] == 'admin') echo 'selected'; ?>>Admin</option>
                            </select>
                        </td>
                        <td class="actions">
                            <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                            <input type="password" name="password" placeholder="New Password">
                            <button name="update"><i class="fa fa-edit"></i> Update</button>
                            <?php if ($user['id'] != $_SESSION['user']['id']): ?>
                                <a href="?delete=<?php echo $user['id']; ?>" onclick="return confirm('Are you sure?')">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                            <?php endif; ?>
                        </td>
                    </form>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <p style="text-align:center; margin-top:2rem;">
        <a href="dashboard.php"><i class="fa fa-home"></i> Dashboard</a> |
        <a href="logout.php"><i class="fa fa-sign-out-alt"></i> Logout</a>
    </p>
</div>
</body>
</html>
