<?php
require 'config.php'; // Ensure this file contains your database connection details

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    $mistralApiKey = $data['mistral_api_key'] ?? '';
    $openrouterApiKey = $data['openrouter_api_key'] ?? '';

    if (empty($mistralApiKey) || empty($openrouterApiKey)) {
        throw new Exception('API keys cannot be empty.');
    }

  $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if there's an existing record
    $stmt = $pdo->query("SELECT id FROM api_keys LIMIT 1");
    $existingRecord = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($existingRecord) {
        // Update existing record
        $stmt = $pdo->prepare("UPDATE api_keys SET mistral_api_key = ?, openrouter_api_key = ? WHERE id = ?");
        $stmt->execute([$mistralApiKey, $openrouterApiKey, $existingRecord['id']]);
    } else {
        // Insert new record
        $stmt = $pdo->prepare("INSERT INTO api_keys (mistral_api_key, openrouter_api_key) VALUES (?, ?)");
        $stmt->execute([$mistralApiKey, $openrouterApiKey]);
    }

    $response['success'] = true;
    $response['message'] = 'API keys saved successfully.';
} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

echo json_encode($response);
?>
