<?php
/* Template Name: ACF Group Fields Form (Create Post with Category) */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

// Check if user is logged in AND has editor/administrator role
if (!is_user_logged_in() || (!current_user_can('editor') && !current_user_can('administrator'))) {
    wp_redirect(home_url());
    exit;
}

get_header();

function get_acf_fields_html_by_group($group_key) {
    $acf_fields = acf_get_fields($group_key);
    $html = '';

    if ($acf_fields) {
        // Get the group title to use as a heading
        $group = acf_get_field_group($group_key);
        $group_title = $group ? esc_html($group['title']) : 'Field Group';

        // Start group container
        $html .= '<div class="acf-field-group" data-group-key="' . esc_attr($group_key) . '">';
        $html .= '<h3 class="group-title">' . $group_title . '</h3>';

        foreach ($acf_fields as $field) {
            $field_name = $field['name'];
            $field_label = esc_html($field['label']);
            $field_type = $field['type'];
            $field_choices = isset($field['choices']) ? $field['choices'] : [];
            $field_instructions = isset($field['instructions']) ? esc_html($field['instructions']) : '';

            // Field container
            $html .= '<div class="acf-field" data-field-name="' . esc_attr($field_name) . '" data-field-type="' . esc_attr($field_type) . '">';

            $html .= '<div class="field-label-container">';
            $html .= '<label for="' . esc_attr($field_name) . '">' . $field_label . '</label>';
            if ($field_instructions) {
                $html .= '<span class="field-instructions">' . $field_instructions . '</span>';
            }
            $html .= '</div>';

            $html .= '<div class="field-input-container">';
            $html .= '<button type="button" class="fill-hello-button" data-target="' . esc_attr($field_name) . '" data-field-type="' . esc_attr($field_type) . '" data-field-label="' . esc_attr($field_label) . '">Generate</button>';

            switch ($field_type) {
                case 'text':
                case 'number':
                case 'email':
                    $html .= '<input type="' . esc_attr($field_type) . '" name="acf[' . esc_attr($field_name) . ']" id="' . esc_attr($field_name) . '" required>';
                    break;

                case 'textarea':
                    $html .= '<textarea name="acf[' . esc_attr($field_name) . ']" id="' . esc_attr($field_name) . '" rows="4" required></textarea>';
                    break;

                case 'select':
                    $html .= '<select name="acf[' . esc_attr($field_name) . ']" id="' . esc_attr($field_name) . '" required>';
                    foreach ($field_choices as $val => $label) {
                        $html .= '<option value="' . esc_attr($val) . '">' . esc_html($label) . '</option>';
                    }
                    $html .= '</select>';
                    break;

                case 'radio':
                    $html .= '<div class="radio-options">';
                    foreach ($field_choices as $val => $label) {
                        $input_id = esc_attr($field_name . '_' . $val);
                        $html .= '<div class="radio-option">';
                        $html .= '<input type="radio" name="acf[' . esc_attr($field_name) . ']" id="' . $input_id . '" value="' . esc_attr($val) . '" required> ';
                        $html .= '<label for="' . $input_id . '">' . esc_html($label) . '</label>';
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                    break;

                case 'checkbox':
                    $html .= '<div class="checkbox-options">';
                    foreach ($field_choices as $val => $label) {
                        $input_id = esc_attr($field_name . '_' . $val);
                        $html .= '<div class="checkbox-option">';
                        $html .= '<input type="checkbox" name="acf[' . esc_attr($field_name) . '][]" id="' . $input_id . '" value="' . esc_attr($val) . '"> ';
                        $html .= '<label for="' . $input_id . '">' . esc_html($label) . '</label>';
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                    break;

                case 'date_picker':
                    $html .= '<input type="date" name="acf[' . esc_attr($field_name) . ']" id="' . esc_attr($field_name) . '" required>';
                    break;

                default:
                    $html .= '<input type="text" name="acf[' . esc_attr($field_name) . ']" id="' . esc_attr($field_name) . '" placeholder="Unsupported field type" required>';
            }
            $html .= '</div>';

            // Close field container
            $html .= '</div>';
        }

        // Close group container
        $html .= '</div>';
    } else {
        $html .= '<div class="acf-field-group error">';
        $html .= '<p>No ACF fields found for the given group key: ' . esc_html($group_key) . '</p>';
        $html .= '</div>';
    }

    return $html;
}

// Define the categories and their corresponding ACF group keys
$category_acf_groups = array(
    "JURISPRUDENCES CCJA OHADA" => ["group_6783007e55f17", "group_6784f500ad7e8"],
    "Arrêts CCJA VF" => ["group_6783007e55f17"],
    "JURISPRUDENCES CEDEAO" => ["group_6799f29595dc8", "group_6782fb656c17a" , "group_6799f37dacf2b"] ,
    "ARTICLES DE DOCTRINE" => ["group_6784fab72405e"],
    "MEMOIRES ET THESES JURIDIQUES" => ["group_6784fc0432d0d"],
    "MODELES ACTES JURIDIQUES ET JUDICIAIRES" => ["group_6784fe6565182"],
    "NOTES JURIDIQUES" => ["group_6784fd7cd844d"],  
    "VEILLE JURIDIQUE ET CONFORMITE" => ["group_6784fb686ac65"],   
    "GUINEE" => ["group_677e454bcdaf0"],   
        "Contrats Miniers Guinée VF" => ["group_677e454bcdaf0"],  
    "OHADA" => ["group_6782a3de235e6"],
     "JURISPRUDENCES GUINEE" => ["group_67827d4e832d3"] ,
    "Sentences Arbitrales Guinée VF" => ["group_67827d4e832d3"] ,
    "CEDEAO" => ["group_67850116e8652"] ,
    "Avis CCJA VF" => ["group_6784f500ad7e8"],
"Arrêts Cour de Justice CEDEAO VF" => ["group_6799f29595dc8"],
"Avis Cour de Justice CEDEAO VF" => ["group_6799f37dacf2b"],
"Ordonnances Cour de Justice CEDEAO VF" => ["group_6799f29595dc8", "group_6782fb656c17a"] ,
"Cour Constitutionnelle VF" => ["group_67827d4e832d3"] ,
"Cour d'Appel Conakry VF" =>	["group_67827d4e832d3"] ,
"Cour d'Appel de Kankan VF" =>	["group_67827d4e832d3"] ,
"Cour de Répression des Infractions Economiques et Financières CRIEF VF" =>	["group_67827d4e832d3"] ,
"Cour des Comptes VF" =>	["group_67827d4e832d3"] ,
"Cour Suprême VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Dalaba VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Dinguiraye VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Gaoual VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Gueckedou VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Koubia VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Lelouma VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Lola VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Mali VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Telimele VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Tougué VF" =>	["group_67827d4e832d3"] ,
"Justice de Paix de Yomou VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Commerce de Conakry VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Boffa VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Boké VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Coyah VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Dixinn VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Dubreka VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Faranah VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Forecariah VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Fria VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Kaloum VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Kankan VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Kerouané" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Kindia VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Kissidougou VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Koundara VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Labé VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Macenta VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Mafanco VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Mamou VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de N'Zerekoré VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Pita VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Première Instance de Siguiri VF" =>	["group_67827d4e832d3"] ,
"Tribunal de Travail de Conakry VF" =>	["group_67827d4e832d3"] ,
"Tribunal Militaire 1ère Instance Permanent de Conakry VF" => ["group_67827d4e832d3"] ,
"Tribunal Militaire à Formation Spéciale de Kankan VF" => ["group_67827d4e832d3"] ,
"Tribunal Militaire à Formation Spéciale de N'Zerekoré VF" => ["group_67827d4e832d3"] ,
"Tribunal pour Enfants VF" => ["group_67827d4e832d3"] ,
"Actes Additionnels VF" => ["group_67850116e8652"] ,
"Communiqués / Déclarations VF" => ["group_67850116e8652"] ,
"Décisions VF" => ["group_67850116e8652"] ,
"Directives VF" => ["group_67850116e8652"] ,
"Protocoles VF" => ["group_67850116e8652"] ,
"Règlements VF" => ["group_67850116e8652"] ,
"Traités VF" => ["group_67850116e8652"] ,
"Arrêtés VF" => ["group_677e454bcdaf0"] ,
"Circulaires VF" => ["group_677e454bcdaf0"] ,
"Communiqués VF" => ["group_677e454bcdaf0"] ,
"Constitutions VF" => ["group_677e454bcdaf0"] ,
"Conventions Collectives VF" => ["group_677e454bcdaf0"] ,
"Décisions VF" => ["group_677e454bcdaf0"] ,
"Décrets VF" => ["group_677e454bcdaf0"] ,
"Lois VF" => ["group_677e454bcdaf0"] ,
"Ordonnances VF" => ["group_677e454bcdaf0"] ,
"Traités et Accords Internationaux VF" => ["group_677e454bcdaf0"] ,
"Actes Uniformes VF" => ["group_677e454bcdaf0"] ,
"Anciens Traités et Actes Uniformes VF" => ["group_6782a3de235e6"] ,
"Décisions CCJA VF" => ["group_6782a3de235e6"] ,
"Règlements CCJA VF" => ["group_6782a3de235e6"] ,
"Traité VF" => ["group_6782a3de235e6"] ,
);
?>

<style>
/* Main Container Styles */
.acf-content {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 2rem;
    background: #fff;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
}

.acf-content h2 {
    color: #2c3e50;
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #eee;
    font-size: 1.8rem;
}

/* Form Styles */
.acf-content form {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.acf-content label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #34495e;
}


.form-group {
    display: block !important;
}

.acf-content input[type="text"],
.acf-content input[type="number"],
.acf-content input[type="email"],
.acf-content input[type="date"],
.acf-content select,
.acf-content textarea {
    width: 100%;
    padding: 0.75rem;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 1rem;
    transition: border-color 0.3s;
}

.acf-content input[type="text"]:focus,
.acf-content input[type="number"]:focus,
.acf-content input[type="email"]:focus,
.acf-content input[type="date"]:focus,
.acf-content select:focus,
.acf-content textarea:focus {
    border-color: #3498db;
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.acf-content textarea {
    min-height: 150px;
    resize: vertical;
}

/* ACF Field Groups */
.acf-field-group {
    background: #f9f9f9;
    border-radius: 6px;
    padding: 1.5rem;
    margin-bottom: 2rem;
    border: 1px solid #eee;
}

.group-title {
    color: #2980b9;
    margin-top: 0;
    margin-bottom: 1.5rem;
    padding-bottom: 0.75rem;
    border-bottom: 1px solid #e0e0e0;
}

/* Individual Field Styles */
.acf-field {
    margin-bottom: 1.5rem;
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    align-items: flex-start;
}

.field-label-container {
    flex: 1 1 200px;
    min-width: 200px;
}

.field-input-container {
    flex: 2 1 300px;
    display: flex;
    flex-direction: row-reverse;
    gap: 0.5rem;
}

.field-instructions {
    display: block;
    font-size: 0.85rem;
    color: #7f8c8d;
    margin-top: 0.25rem;
    font-style: italic;
}

/* Radio and Checkbox Styles */
.radio-options,
.checkbox-options {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.radio-option,
.checkbox-option {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.radio-option input[type="radio"],
.checkbox-option input[type="checkbox"] {
    margin: 0;
}

/* Button Styles */
.fill-hello-button {
    background: #3498db;
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 4px;
    cursor: pointer;
    font-size: 0.9rem;
    transition: background 0.3s;
    align-self: flex-start;
}

.fill-hello-button:hover {
    background: #2980b9;
}

.fill-hello-button:disabled {
    background: #95a5a6;
    cursor: not-allowed;
}

#generate-all-fields {
    background: #2ecc71;
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 4px;
    cursor: pointer;
    font-size: 0.9rem;
    transition: background 0.3s;
}

#generate-all-fields:hover {
    background: #27ae60;
}

#generate-all-fields:disabled {
    background: #95a5a6;
    cursor: not-allowed;
}

input[type="submit"] {
    background: #2ecc71;
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 4px;
    cursor: pointer;
    font-size: 1rem;
    font-weight: 600;
    transition: background 0.3s;
    margin-top: 1rem;
    align-self: flex-start;
}

input[type="submit"]:hover {
    background: #27ae60;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .acf-field {
        flex-direction: column;
    }
    
    .field-label-container,
    .field-input-container {
        flex: 1 1 100%;
        width: 100%;
    }
    
    .acf-content {
        padding: 1rem;
    }
}

/* Success/Error Messages */
.acf-content p[style*="color:red"] {
    background: #ffecec;
    padding: 1rem;
    border-radius: 4px;
    border-left: 4px solid #e74c3c;
}

.acf-content p:has(> ✅) {
    background: #e8f8f0;
    padding: 1rem;
    border-radius: 4px;
    border-left: 4px solid #2ecc71;
}

.acf-content p:has(> ❌) {
    background: #ffecec;
    padding: 1rem;
    border-radius: 4px;
    border-left: 4px solid #e74c3c;
}

.acf-content p a {
    color: #3498db;
    text-decoration: none;
    font-weight: 600;
}

.acf-content p a:hover {
    text-decoration: underline;
}

/* TinyMCE Editor Container */
.wp-editor-container {
    border: 1px solid #ddd;
    border-radius: 4px;
    overflow: hidden;
}

/* Category Select Container */
#post_category {
    max-width: 400px;
}
</style>

<div class="acf-content">

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['acf_post_nonce']) || !wp_verify_nonce($_POST['acf_post_nonce'], 'acf_post_create')) {
            die('Security check failed');
        }

        $post_title    = sanitize_text_field($_POST['post_title']);
        $post_content  = wp_kses_post($_POST['post_content']);
        $post_category = intval($_POST['post_category']);
        $acf_fields    = isset($_POST['acf']) ? $_POST['acf'] : [];

        // Check if ACF fields are all filled
        $missing_acf_fields = [];
        foreach ($acf_fields as $key => $val) {
            if (is_array($val)) {
                if (empty($val)) $missing_acf_fields[] = $key;
            } else {
                if (trim($val) === '') $missing_acf_fields[] = $key;
            }
        }

        if (empty($post_title) || empty($post_content) || empty($post_category) || !empty($missing_acf_fields)) {
            echo '<p style="color:red;">❌ Please fill in all required fields.</p>';
        } else {
            $post_id = wp_insert_post([
                'post_title'   => $post_title,
                'post_content' => $post_content,
                'post_status'  => 'publish',
                'post_author'  => get_current_user_id(),
                'post_type'    => 'post',
            ]);

            if ($post_id) {
                wp_set_post_categories($post_id, [$post_category]);

                foreach ($acf_fields as $field_name => $value) {
                    update_field($field_name, $value, $post_id);
                }

                echo '<p>✅ Post created successfully with category and ACF fields!</p>';
                echo '<p><a href="' . get_permalink($post_id) . '" target="_blank">View Post</a></p>';
            } else {
                echo '<p>❌ Error creating post.</p>';
            }
        }
    } else {
    ?>
        <form method="POST" action="">
            <?php wp_nonce_field('acf_post_create', 'acf_post_nonce'); ?>

            <div class="form-group">
                <label for="post_title">Post Title:</label>
                <input type="text" id="post_title" name="post_title" required>
            </div>

            <div class="form-group">
                <label for="post_content">Post Content:</label>
                <?php
                wp_editor('', 'post_content', array(
                    'textarea_name' => 'post_content',
                    'textarea_rows' => 10,
                    'media_buttons' => true,
                    'tinymce' => true,
                    'quicktags' => true
                ));
                ?>
            </div>

<div class="form-group">
    <label for="post_category">Category:</label>
    <div style="display: flex; align-items: center; gap: 10px;">
        <select id="post_category" name="post_category" required style="flex-grow: 1;">
            <option value="">Select a Category</option>
            <?php
            $all_categories = get_categories([
                'orderby' => 'name',
                'order' => 'ASC',
                'hide_empty' => false, // Include categories with no posts
            ]);
            foreach ($all_categories as $cat) {
                echo '<option value="' . esc_attr($cat->term_id) . '">' . esc_html($cat->name) . '</option>';
            }
            ?>
        </select>
        <button type="button" id="generate-all-fields">Generate All Fields</button>
    </div>
</div>


            <div id="acf-fields-container"></div>

            <input type="submit" value="Create Post">
        </form>

        <script>
            const categoryACFFields = <?php
                $map = [];
                foreach ($category_acf_groups as $category_name => $group_keys) {
                    $html = '';
                    foreach ($group_keys as $key) {
                        $html .= get_acf_fields_html_by_group($key);
                    }
                    $map[$category_name] = $html;
                }
                echo json_encode($map);
            ?>;

            function showACFFields() {
                const select = document.getElementById('post_category');
                const selectedText = select.options[select.selectedIndex].text;
                const container = document.getElementById('acf-fields-container');
                container.innerHTML = categoryACFFields[selectedText] || '';
            }

            // Function to generate all fields
            async function generateAllFields() {
                const buttons = document.querySelectorAll('.fill-hello-button');

                // Disable the generate all button
                const generateAllBtn = document.getElementById('generate-all-fields');
                generateAllBtn.textContent = "Generating all fields...";
                generateAllBtn.disabled = true;

                // Process each field one by one
                for (let i = 0; i < buttons.length; i++) {
                    const button = buttons[i];

                    // Skip if button is already processing
                    if (button.disabled) continue;

                    // Simulate click on each generate button
                    button.click();

                    // Wait for the API call to complete
                    await new Promise(resolve => {
                        const checkCompletion = setInterval(() => {
                            if (!button.disabled) {
                                clearInterval(checkCompletion);
                                resolve();
                            }
                        }, 100);
                    });

                    // Add delay between requests to avoid rate limiting
                    await new Promise(resolve => setTimeout(resolve, 2000)); // 2 seconds delay

                    // Check if the field is filled
                    const target = document.getElementById(button.getAttribute('data-target'));
                    if (!target || !target.value.trim()) {
                        alert('Error: One of the fields could not be filled. Please check and try again.');
                        generateAllBtn.textContent = "Generate All Fields";
                        generateAllBtn.disabled = false;
                        return;
                    }
                }

                // Re-enable the generate all button
                generateAllBtn.textContent = "Generate All Fields";
                generateAllBtn.disabled = false;
            }

            document.addEventListener('DOMContentLoaded', function () {
                const select = document.getElementById('post_category');
                select.addEventListener('change', showACFFields);
                select.addEventListener('click', showACFFields);

                // Add event listener for the generate all button
                document.getElementById('generate-all-fields').addEventListener('click', generateAllFields);
            });

            // Function to parse various date formats and convert to YYYY-MM-DD
            function parseDateString(dateStr) {
                if (!dateStr) return null;

                // Try ISO format (YYYY-MM-DD)
                if (/^\d{4}-\d{2}-\d{2}$/.test(dateStr)) {
                    return dateStr;
                }

                // Try French format (DD/MM/YYYY)
                const frenchMatch = dateStr.match(/^(\d{2})\/(\d{2})\/(\d{4})$/);
                if (frenchMatch) {
                    return `${frenchMatch[3]}-${frenchMatch[2]}-${frenchMatch[1]}`;
                }

                // Try French month name format (e.g., "15 janvier 2023")
                const monthNames = {
                    'janvier': '01', 'février': '02', 'mars': '03', 'avril': '04',
                    'mai': '05', 'juin': '06', 'juillet': '07', 'août': '08',
                    'septembre': '09', 'octobre': '10', 'novembre': '11', 'décembre': '12'
                };

                const frenchMonthMatch = dateStr.match(/^(\d{1,2})\s+([a-zA-Zéû]+)\s+(\d{4})$/);
                if (frenchMonthMatch) {
                    const day = frenchMonthMatch[1].padStart(2, '0');
                    const month = monthNames[frenchMonthMatch[2].toLowerCase()] || '01';
                    const year = frenchMonthMatch[3];
                    return `${year}-${month}-${day}`;
                }

                // Try to parse as a date object
                const parsedDate = new Date(dateStr);
                if (!isNaN(parsedDate.getTime())) {
                    return parsedDate.toISOString().split('T')[0];
                }

                return null;
            }

            document.addEventListener('click', async function (e) {
                if (e.target && e.target.classList.contains('fill-hello-button')) {
                    const fieldName = e.target.getAttribute('data-target');
                    const fieldType = e.target.getAttribute('data-field-type');
                    const fieldLabel = e.target.getAttribute('data-field-label');
                    const target = document.getElementById(fieldName);

                    if (!target) return;

                    // Store original button text and disable button
                    const button = e.target;
                    const originalText = button.textContent;
                    button.textContent = "Generating...";
                    button.disabled = true;

                    try {
                        // Get the content from TinyMCE editor
                        let content = '';
                        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('post_content')) {
                            content = tinyMCE.get('post_content').getContent({format: 'text'});
                        } else {
                            content = document.getElementById('post_content').value;
                        }

                        // Generate prompt based on field type and label
                        let prompt = '';
                        let choices = [];

const fieldId = target.id; // Make sure to get the id from the input

switch (fieldType) {
    case 'text':
        if (fieldId === 'mots_cles_lies_a_larret') {
            prompt = `Based on this legal content: "${content.substring(0, 500)}", Analyse le texte ou la décision de justice et identifie uniquement les mots clé ou expressions qui renvoient à des notions ou sujets techniques, juridiques ou réglementaires traités dans la décision (ex. : "responsabilité contractuelle", "autorisation d’exploiter", "permis minier", "preuve par écrit", "clause abusive", etc.). Exclue les éléments de procédure (noms, dates, juridictions, numéros de dossier,). Présente les termes sous forme de liste thématique ou catégorisée si possible (donnee la response sans tag)`;
        } else {
            prompt = `Based on content: "${content.substring(0, 900)}", donnes moi le ${fieldLabel} (donnee la response sans tag respect format)`;
        }
        break;

    case 'number':
        prompt = `Provide a realistic number value for ${fieldLabel} based on this legal content: "${content.substring(0, 500)}". Provide only the number without any additional text.`;
        break;

    case 'email':
        prompt = `Provide a realistic email address for ${fieldLabel} based on this legal content: "${content.substring(0, 500)}". Provide only the email without any additional text.`;
        break;

    case 'textarea':
        prompt = `Based on this legal content: "${content.substring(0, 500)}", generate a relevant ${fieldLabel} (2-3 sentences). Provide only the text without any additional explanation.`;
        break;

    case 'date_picker':
        prompt = `Analyze this legal content: "${content.substring(0, 900)}" and identify the most relevant date for "${fieldLabel}".
The date could be mentioned explicitly (in any format like YYYY-MM-DD, DD/MM/YYYY, or "15 janvier 2023") or inferred from context.
First look for explicit dates mentioned in the text that relate to ${fieldLabel}.
If no explicit date is found, infer the most likely date from the context.
Respond ONLY with the date in YYYY-MM-DD format, nothing else.
If no date can be determined, respond with today's date in YYYY-MM-DD format.`;
        break;

    case 'select':
    case 'radio':
    case 'checkbox':
        if (target.tagName === 'SELECT') {
            const options = target.options;
            choices = Array.from(options).map(opt => opt.text);

            prompt = `Based on this legal content: "${content.substring(0, 500)}", select the most appropriate option for "${fieldLabel}" from these choices: ${choices.join(', ')}.
Respond ONLY with the exact text of the chosen option, nothing else.`;
        } else if (target.tagName === 'INPUT' && (fieldType === 'radio' || fieldType === 'checkbox')) {
            const inputs = document.querySelectorAll(`input[type="${fieldType}"][name="acf[${fieldName}]${fieldType === 'checkbox' ? '[]' : ''}"]`);
            choices = Array.from(inputs).map(input => {
                const label = document.querySelector(`label[for="${input.id}"]`);
                return label ? label.textContent : '';
            });

            prompt = `Based on this legal content: "${content.substring(0, 500)}", select the most appropriate option for "${fieldLabel}" from these choices: ${choices.join(', ')}.
Respond ONLY with the exact text of the chosen option, nothing else.`;
        }
        break;

    default:
        prompt = `Based on this legal content: "${content.substring(0, 500)}", generate a relevant ${fieldLabel}. Provide only the value without any additional text.`;
}


                        // Call Mistral AI API
                        const apiKey = 'EiHM3BjAHEXwca6C76Cczf9SyyZIHx1g';
                        const url = 'https://api.mistral.ai/v1/chat/completions';

                        const response = await fetch(url, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'Authorization': `Bearer ${apiKey}`
                            },
                            body: JSON.stringify({
                                model: 'mistral-large-latest',
                                messages: [{ role: 'user', content: prompt }],
                                max_tokens: 500,
                                temperature: 0.6
                            })
                        });

                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }

                        const data = await response.json();
                        let sampleValue = data.choices[0].message.content.trim();

                        // Clean up the response
                        sampleValue = sampleValue.replace(/^['"]|['"]$/g, '').trim();

                        // Special handling for date fields
                        if (fieldType === 'date_picker') {
                            const parsedDate = parseDateString(sampleValue);
                            if (parsedDate) {
                                sampleValue = parsedDate;
                            } else {
                                // Fallback to today's date if parsing fails
                                const today = new Date();
                                sampleValue = today.toISOString().split('T')[0];
                            }
                        } else if (fieldType === 'email') {
                            if (!sampleValue.includes('@')) {
                                sampleValue = 'example@domain.com';
                            }
                        }

                        // Handle select, radio, and checkbox fields
                        if (fieldType === 'select' || fieldType === 'radio' || fieldType === 'checkbox') {
                            // Find the option that matches the AI's response
                            let matchedOption = null;

                            if (target.tagName === 'SELECT') {
                                // For select fields
                                const options = target.options;
                                for (let i = 0; i < options.length; i++) {
                                    if (options[i].text.trim() === sampleValue.trim()) {
                                        matchedOption = options[i];
                                        break;
                                    }
                                }

                                if (matchedOption) {
                                    target.value = matchedOption.value;
                                    const event = new Event('change');
                                    target.dispatchEvent(event);
                                } else if (options.length > 0) {
                                    // Fallback to first option if no match found
                                    target.value = options[0].value;
                                    const event = new Event('change');
                                    target.dispatchEvent(event);
                                }
                            } else if (target.tagName === 'INPUT' && (fieldType === 'radio' || fieldType === 'checkbox')) {
                                // For radio/checkbox fields
                                const inputs = document.querySelectorAll(`input[type="${fieldType}"][name="acf[${fieldName}]${fieldType === 'checkbox' ? '[]' : ''}"]`);
                                let matchedInput = null;

                                for (let i = 0; i < inputs.length; i++) {
                                    const label = document.querySelector(`label[for="${inputs[i].id}"]`);
                                    if (label && label.textContent.trim() === sampleValue.trim()) {
                                        matchedInput = inputs[i];
                                        break;
                                    }
                                }

                                if (matchedInput) {
                                    matchedInput.checked = true;
                                    const event = new Event('change');
                                    matchedInput.dispatchEvent(event);
                                } else if (inputs.length > 0) {
                                    // Fallback to first option if no match found
                                    inputs[0].checked = true;
                                    const event = new Event('change');
                                    inputs[0].dispatchEvent(event);
                                }
                            }
                        } else {
                            // Set the value for input/textarea fields
                            if (target.tagName === 'INPUT' || target.tagName === 'TEXTAREA') {
                                target.value = sampleValue;
                                const event = new Event('change');
                                target.dispatchEvent(event);
                            }
                        }

                    } catch (error) {
                        console.error('Error generating sample:', error);
                        alert('Error generating sample. Please try again.');

                        // Re-enable the button and stop further processing
                        button.textContent = originalText;
                        button.disabled = false;
                        return;
                    } finally {
                        button.textContent = originalText;
                        button.disabled = false;
                    }
                }
            });
        </script>
    <?php } ?>
</div>

<?php get_footer(); ?>