function custom_search_form() {
    // Get all categories
    $categories = get_categories();
    
    // HTML form
    ?>
    <form action="<?php echo esc_url(home_url('/')); ?>" method="get">
        <div>
            <!-- Keyword Input -->
            <label for="s">Enter keyword:</label>
            <input type="text" name="s" id="s" value="<?php echo isset($_GET['s']) ? esc_attr($_GET['s']) : ''; ?>" />
        </div>

        <div>
            <!-- Category Dropdown -->
            <label for="category">Category:</label>
            <select name="category" id="category">
                <option value="">Select Category</option>
                <?php foreach ($categories as $category) : ?>
                    <option value="<?php echo esc_attr($category->term_id); ?>" <?php selected(isset($_GET['category']) && $_GET['category'] == $category->term_id); ?>>
                        <?php echo esc_html($category->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div id="sub-category-div" style="display:none;">
            <!-- Sub-Category Dropdown (Initially hidden) -->
            <label for="subcategory">Sub-Category:</label>
            <select name="subcategory" id="subcategory">
                <!-- Sub-category options will be populated by JavaScript based on selected category -->
            </select>
        </div>

        <div>
            <!-- Advanced Search Checkbox -->
            <label for="advanced-search">
                <input type="checkbox" name="advanced-search" id="advanced-search" <?php checked(isset($_GET['advanced-search'])); ?> />
                Advanced Search
            </label>
        </div>

        <div>
            <!-- Search Button -->
            <button type="submit">Search</button>
        </div>
    </form>

    <script>
        // Show or hide the sub-category based on category selection
        document.getElementById('category').addEventListener('change', function() {
            var categoryId = this.value;
            var subCategoryDiv = document.getElementById('sub-category-div');
            
            if (categoryId) {
                subCategoryDiv.style.display = 'block';
                loadSubCategories(categoryId);
            } else {
                subCategoryDiv.style.display = 'none';
            }
        });

        // Load sub-categories via AJAX when a category is selected
        function loadSubCategories(categoryId) {
            var subCategorySelect = document.getElementById('subcategory');
            subCategorySelect.innerHTML = ''; // Clear existing options

            fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=load_subcategories&category_id=' + categoryId)
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        var defaultOption = document.createElement('option');
                        defaultOption.value = '';
                        defaultOption.textContent = 'Select Sub-Category';
                        subCategorySelect.appendChild(defaultOption);

                        data.forEach(function(subCategory) {
                            var option = document.createElement('option');
                            option.value = subCategory.term_id;
                            option.textContent = subCategory.name;
                            subCategorySelect.appendChild(option);
                        });
                    }
                });
        }
    </script>
    <?php
}

// Hook the custom search form to a WordPress hook (e.g., widget or theme template)
add_shortcode('custom_search_form', 'custom_search_form');

// Add AJAX handler to load sub-categories based on category
function load_subcategories() {
    $category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;

    if ($category_id) {
        $subcategories = get_categories(array(
            'child_of' => $category_id,
            'orderby' => 'name',
            'order' => 'ASC'
        ));

        $result = array();

        foreach ($subcategories as $subcategory) {
            $result[] = array(
                'term_id' => $subcategory->term_id,
                'name' => $subcategory->name
            );
        }

        wp_send_json($result);
    }

    wp_die(); // Terminate to prevent further output
}

add_action('wp_ajax_load_subcategories', 'load_subcategories');
add_action('wp_ajax_nopriv_load_subcategories', 'load_subcategories');