<?php

// Turn on error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- 1. Configuration ---
// Set the full path to your project directory and virtual environment
$project_path = '/home/guilaw/public_html/app.kytisa.com/';
$venv_path = $project_path . 'rag/bin/activate';

// Define the arguments for your Python script
$arg1 = 'wp-single';
$arg2 = '75050';

// --- 2. Security ---
// Sanitize arguments to prevent command injection attacks. This is VERY important.
$safe_arg1 = escapeshellarg($arg1);
$safe_arg2 = escapeshellarg($arg2);

// --- 3. Build the Command ---
// This single command string chains all necessary steps together.
// The `2>&1` at the end redirects any errors to the output, so you can see them.
$command = sprintf(
    'source %s && cd %s && python3 rag_app00.py %s %s 2>&1',
    escapeshellarg($venv_path),     // Path to venv activate script
    escapeshellarg($project_path), // Path to project directory
    $safe_arg1,                    // First script argument
    $safe_arg2                     // Second script argument
);

// --- 4. Execute and Display Output ---
// Use shell_exec() to run the command and capture the result.
$output = shell_exec($command);

// Display the captured output from the Python script.
// The <pre> tag preserves whitespace and newlines for easier reading.
echo "<h1>RAG Script Output</h1>";
echo "<pre>" . htmlspecialchars($output) . "</pre>";

?>