<?php
require_once '/home/icatchagency/guilaw.icatchagency.com/pdf/vendor/autoload.php';

class PDFWithHeaderFooter extends TCPDF {
    // Page header
    public function Header() {
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(0, 10, 'My PDF Header', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

    // Page footer
    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 10);
        $this->Cell(0, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(),
            0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

    // Watermark method (must be inside the class)
    public function RotatedText($x, $y, $txt, $angle) {
        $this->StartTransform();
        $this->Rotate($angle, $x, $y);
        $this->Text($x, $y, $txt);
        $this->StopTransform();
    }
}

// Create new PDF document
$pdf = new PDFWithHeaderFooter(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Document settings
$pdf->SetCreator('Your Name');
$pdf->SetAuthor('Your Name');
$pdf->SetTitle('HTML to PDF with Watermark');
$pdf->SetSubject('TCPDF Example');

$pdf->SetMargins(15, 27, 15);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(15);
$pdf->SetAutoPageBreak(TRUE, 25);
$pdf->SetFont('dejavusans', '', 12);

// Add a page
$pdf->AddPage();

// Watermark
$pdf->SetAlpha(0.6);
$pdf->SetFont('helvetica', 'B', 14);
$pdf->RotatedText(35, 190, 'WATERMARK', 45);
$pdf->SetAlpha(1);


// HTML content
$html = <<<HTML
{$content}
HTML;

// Render HTML
$pdf->writeHTML($html, true, false, true, false, '');

// Output PDF
$pdf->Output('example.pdf', 'I');
