<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $file = $_FILES['file'];
    $filePath = $file['tmp_name'];
    $fileName = $file['name'];
    $fileType = $file['type'];

    // Check if the file is a .docx file
    if ($fileType === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') {
        // Load the .docx file
        $zip = new ZipArchive();
        if ($zip->open($filePath) === TRUE) {
            // Read the content of the document.xml file within the .docx archive
            $documentXml = $zip->getFromName('word/document.xml');
            $zip->close();

            // Load the XML content
            $xml = new DOMDocument();
            $xml->loadXML($documentXml);

            // Extract text from the XML content
            $xpath = new DOMXPath($xml);
            $paragraphs = $xpath->query('//w:p');
            $textContent = '';

            foreach ($paragraphs as $paragraph) {
                $texts = $xpath->query('.//w:t', $paragraph);
                foreach ($texts as $text) {
                    $textContent .= $text->nodeValue . ' ';
                }
            }

            // Output the extracted text
            echo '<div id="response">' . nl2br(htmlspecialchars($textContent)) . '</div>';
        } else {
            echo '<div id="response">Erreur lors de l\'ouverture du fichier .docx.</div>';
        }
    } else {
        echo '<div id="response">Veuillez télécharger un fichier .docx valide.</div>';
    }
} else {
    echo '<div id="response">Aucun fichier téléchargé.</div>';
}
?>
