<?php
/*
Plugin Name: OpenRouter Chatbot
Description: Adds a popup OpenRouter chatbot with a switchable API backend.
Version: 3.2
Author: Your Name
*/

// --- PROXY FOR KYTISA API ---
// This PHP part is correct and remains unchanged.
add_action('rest_api_init', function () {
    register_rest_route('chatbot/v1', '/kytisa-query', array(
        'methods' => 'POST',
        'callback' => 'handle_kytisa_proxy_request',
        'permission_callback' => function () {
            if (!is_user_logged_in()) {
                return new WP_Error('rest_forbidden', 'Désolé, vous n\'êtes pas autorisé à faire cela.', array('status' => 401));
            }
            $user = wp_get_current_user();
            $user_level = get_user_meta($user->ID, 'custom_category_access_level', true);
            if (in_array('administrator', (array) $user->roles, true) || $user_level === 'level_3' || $user_level === 'level_0') {
                return true;
            }
            return new WP_Error('rest_forbidden', 'Désolé, vous n\'êtes pas autorisé à faire cela.', array('status' => 403));
        }
    ));
});

function handle_kytisa_proxy_request(WP_REST_Request $request) {
    $user_query = $request->get_param('query');
    if (empty($user_query)) {
        return new WP_Error('bad_request', 'La requête est vide.', array('status' => 400));
    }

    $api_url = 'https://app.kytisa.com/query?text=' . urlencode($user_query);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $body = curl_exec($ch);
    $curl_error = curl_error($ch);
    $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($curl_error || $status_code !== 200) {
        return new WP_Error('api_error', 'Erreur de communication avec le service Kytisa.', array('status' => 502));
    }

    if (function_exists('mb_convert_encoding')) {
        $body = mb_convert_encoding($body, 'UTF-8', 'auto');
    }

    $decoded_data = json_decode($body, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        return new WP_Error('json_error', 'Réponse invalide de l\'API Kytisa.', array('status' => 500));
    }

    return new WP_REST_Response($decoded_data, 200);
}


// --- MAIN PLUGIN LOGIC ---
add_action('wp', function () {
    if (!is_user_logged_in()) return;

    $user       = wp_get_current_user();
    $user_level = get_user_meta($user->ID, 'custom_category_access_level', true);

    if (
        in_array('administrator', (array) $user->roles, true)
        || $user_level === 'level_3'
        || $user_level === 'level_0'
    ) {
        add_action('wp_enqueue_scripts', function () {
            wp_enqueue_script('jquery');
            wp_enqueue_script('marked-js', 'https://cdn.jsdelivr.net/npm/marked/marked.min.js', array(), null, true);

            $post_data = array(
                'is_singular' => is_singular(),
                'content' => '',
                'title' => '',
                'site_name' => get_bloginfo('name'),
                'rest_url' => esc_url_raw(rest_url()),
                'nonce' => wp_create_nonce('wp_rest')
            );
            
            if (is_singular()) {
                global $post;
                $post_content = apply_filters('the_content', $post->post_content);
                $stripped_content = wp_strip_all_tags($post_content);
                $post_data['content'] = $stripped_content;
                $post_data['title'] = get_the_title($post->ID);
            }

            wp_localize_script('jquery', 'postData', $post_data);
        });

        add_action('wp_footer', function () {
            ?>
            <style>
                /* --- START OF NEW/UPDATED CSS --- */
                #chat-header {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    padding: 20px 20px 15px;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    font-weight: 600;
                    font-size: 16px;
                }
                #chat-header-controls {
                    display: flex;
                    align-items: center;
                    gap: 15px;
                }
                .api-switch-container {
                    display: flex;
                    align-items: center;
                    gap: 8px;
                    font-size: 12px;
                    font-weight: 500;
                }
                .switch {
                    position: relative;
                    display: inline-block;
                    width: 34px;
                    height: 20px;
                }
                .switch input { 
                    opacity: 0;
                    width: 0;
                    height: 0;
                }
                .slider {
                    position: absolute;
                    cursor: pointer;
                    top: 0;
                    left: 0;
                    right: 0;
                    bottom: 0;
                    background-color: #ccc;
                    transition: .4s;
                    border-radius: 20px;
                }
                .slider:before {
                    position: absolute;
                    content: "";
                    height: 14px;
                    width: 14px;
                    left: 3px;
                    bottom: 3px;
                    background-color: white;
                    transition: .4s;
                    border-radius: 50%;
                }
                input:checked + .slider {
                    background-color: #667eea;
                }
                input:checked + .slider:before {
                    transform: translateX(14px);
                }
                /* --- END OF NEW/UPDATED CSS --- */

                /* Other styles remain the same */
                #openrouter-chatbot-container{position:fixed;bottom:20px;right:20px;z-index:9999;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Oxygen,Ubuntu,Cantarell,sans-serif}#openrouter-chat-toggle{margin-bottom:8px;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);color:#fff;padding:15px;border-radius:50%;cursor:pointer;font-size:22px;text-align:center;box-shadow:0 8px 25px rgba(102,126,234,.4);transition:all .3s cubic-bezier(.4,0,.2,1);width:60px;height:60px;display:flex;align-items:center;justify-content:center;border:none;position:relative;overflow:hidden}#openrouter-chat-toggle:hover{transform:translateY(-2px) scale(1.05);box-shadow:0 12px 35px rgba(102,126,234,.6)}#openrouter-chatbox{width:350px;height:480px;background:#fff;border:none;border-radius:20px;overflow:hidden;display:none;flex-direction:column;margin-bottom:15px;box-shadow:0 20px 60px rgba(0,0,0,.15);transform:translateY(10px) scale(.95);opacity:0;transition:all .3s cubic-bezier(.4,0,.2,1)}#openrouter-chatbox.visible{display:flex;transform:translateY(0) scale(1);opacity:1}#clear-chat{background:rgba(255,255,255,.1);border:1px solid rgba(255,255,255,.2);color:#fff;cursor:pointer;font-size:12px;padding:6px 12px;border-radius:15px;transition:all .2s ease;font-weight:500}#chatbox{flex:1;padding:20px;overflow-y:auto;font-size:14px;background:#f8fafc}#input-area{display:flex;border-top:1px solid #e2e8f0;background:#fff;padding:15px;gap:10px}#userInput{flex:1;padding:12px 16px;border:2px solid #e2e8f0;font-size:14px;border-radius:25px;outline:0;transition:all .2s ease;background:#f8fafc}#userInput:focus{border-color:#667eea;background:#fff;box-shadow:0 0 0 3px rgba(102,126,234,.1)}#input-area button{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);color:#fff;border:none;padding:12px 20px;cursor:pointer;font-size:14px;border-radius:25px;font-weight:600}.message{margin:10px 0;padding:12px 16px;border-radius:18px;max-width:85%;position:relative;line-height:1.5;word-wrap:break-word;animation:messageSlide .3s ease-out}@keyframes messageSlide{0%{opacity:0;transform:translateY(10px)}to{opacity:1;transform:translateY(0)}}.message.user{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);color:#fff;align-self:flex-end;margin-left:auto;border-bottom-right-radius:6px}.message.assistant{background:#fff;color:#374151;align-self:flex-start;border:1px solid #e5e7eb;border-bottom-left-radius:6px}.message.system{background:linear-gradient(135deg,#10b981 0%,#059669 100%);color:#fff;align-self:center;margin:10px auto;border-radius:15px;font-size:13px;text-align:center;max-width:95%}.typing-indicator{display:flex;align-items:center;padding:10px 0}.typing-indicator span{height:8px;width:8px;margin:0 3px;background-color:#cbd5e1;border-radius:50%;display:inline-block;animation:typing-bounce 1.4s infinite ease-in-out both}.typing-indicator span:nth-child(1){animation-delay:-.32s}.typing-indicator span:nth-child(2){animation-delay:-.16s}@keyframes typing-bounce{0%,80%,100%{transform:scale(0)}40%{transform:scale(1)}}.message p{margin:0 0 8px}.message p:last-child{margin-bottom:0}.message code{background:rgba(0,0,0,.1);padding:2px 6px;border-radius:4px;font-size:12px}.message pre{background:rgba(0,0,0,.05);padding:10px;border-radius:8px;overflow-x:auto;margin:8px 0}.message ul,.message ol{margin:8px 0;padding-left:20px}.message a{color:#5a67d8;text-decoration:underline}.message li{margin:4px 0}.message hr{border:none;border-top:1px solid #e2e8f0;margin:12px 0}.confirm-modal-overlay{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,.5);z-index:10000;display:none;align-items:center;justify-content:center}.confirm-modal{background:#fff;padding:25px;border-radius:15px;text-align:center;box-shadow:0 10px 30px rgba(0,0,0,.1);max-width:320px}.confirm-modal p{margin:0 0 20px;font-size:16px;color:#333}.confirm-modal-buttons button{padding:10px 20px;border:none;border-radius:8px;cursor:pointer;font-size:14px;font-weight:600;margin:0 8px}#confirm-ok-btn{background-color:#ef4444;color:#fff}#confirm-cancel-btn{background-color:#e5e7eb;color:#374151}
            </style>

            <div id="openrouter-chatbot-container">
                 <div id="openrouter-chat-toggle"><span>💬</span></div>
                <div id="openrouter-chatbox">
                    <div id="chat-header">
                        <span>Assistant Kytisa</span>
                        <!-- START OF UPDATED HTML -->
                        <div id="chat-header-controls">
                            <div class="api-switch-container">
                                <span>Kytisa LLM</span>
                                <label class="switch">
                                    <input type="checkbox" id="api-toggle">
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <button id="clear-chat">Vider</button>
                        </div>
                        <!-- END OF UPDATED HTML -->
                    </div>
                    <div id="chatbox"></div>
                    <div id="input-area">
                        <input type="text" id="userInput" placeholder="Posez une question..." autocomplete="off" />
                        <button id="send-btn">Envoyer</button>
                    </div>
                </div>
            </div>

            <div class="confirm-modal-overlay" id="clear-chat-modal">
                <div class="confirm-modal">
                    <p>Êtes-vous sûr de vouloir vider l'historique ?</p>
                    <div class="confirm-modal-buttons">
                        <button id="confirm-cancel-btn">Annuler</button>
                        <button id="confirm-ok-btn">Vider</button>
                    </div>
                </div>
            </div>

            <script>
            jQuery(document).ready(function ($) {
                // --- SETUP ---
                const openRouterApiKey = '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';
                const openRouterModel = 'deepseek/deepseek-chat-v3-0324';
                const openRouterApiUrl = 'https://openrouter.ai/api/v1/chat/completions';
                
                const globalSessionKey = 'openrouter_chat_global_session_v4';
                const currentPageKey = 'openrouter_current_page_v4';
                const apiSwitchKey = 'openrouter_api_switch_state_v1';

                const chatboxEl = $('#openrouter-chatbox');
                const chatToggleBtn = $('#openrouter-chat-toggle');
                const chatHistoryEl = $('#chatbox');
                const userInputEl = $('#userInput');
                const sendBtn = $('#send-btn');
                const clearChatBtn = $('#clear-chat');
                const clearChatModal = $('#clear-chat-modal');
                const confirmOkBtn = $('#confirm-ok-btn');
                const confirmCancelBtn = $('#confirm-cancel-btn');
                const apiSwitchEl = $('#api-toggle'); // New switch element
                
                let conversationHistory = [];
                try {
                    const storedHistory = localStorage.getItem(globalSessionKey);
                    if (storedHistory) conversationHistory = JSON.parse(storedHistory);
                } catch (e) { console.error("Error parsing history", e); }

                // --- HELPER FUNCTIONS (unchanged) ---
                function createSystemPrompt() { /* ... */ }
                function setInputState(disabled) { /* ... */ }
                function saveConversation() { /* ... */ }
                function appendMessage(role, content) { /* ... */ }
                function updateAssistantMessage(elementId, content) { /* ... */ }
                function appendSystemMessage(content) { /* ... */ }
                function displayConversationHistory() { /* ... */ }
                function scrollToBottom() { /* ... */ }
                // (All helper functions are present but hidden here for brevity)
                 function createSystemPrompt() {
                    let basePrompt = `Vous êtes un assistant IA pour le site ${postData.site_name}.`;
                    if (postData.is_singular) {
                        basePrompt += ` Vous consultez la page "${postData.title}".`;
                        if (apiSwitchEl.is(':checked') === false && postData.content) { // Provide context only for OpenRouter
                            basePrompt += ` Voici son contenu pour référence : ${postData.content.substring(0, 3000)}`;
                        }
                    }
                    return { role: "system", content: basePrompt };
                }
                function setInputState(disabled) { userInputEl.prop('disabled', disabled); sendBtn.prop('disabled', disabled); if (!disabled) userInputEl.focus(); }
                function saveConversation() { try { localStorage.setItem(globalSessionKey, JSON.stringify(conversationHistory)); } catch (e) { console.error("Could not save conversation", e); } }
                function appendMessage(role, content) { let htmlContent = $('<div>').text(content).html(); if(role === 'assistant' && window.marked) { htmlContent = marked.parse(content); } const div = $('<div>').addClass('message ' + role).html(htmlContent); chatHistoryEl.append(div); scrollToBottom(); }
                function updateAssistantMessage(elementId, content) { const assistantDiv = $('#' + elementId); if (window.marked) { assistantDiv.html(marked.parse(content)); } else { assistantDiv.text(content); } }
                function appendSystemMessage(content) { const div = $('<div>').addClass('message system').text(content); chatHistoryEl.append(div); scrollToBottom(); }
                function displayConversationHistory() { chatHistoryEl.empty(); conversationHistory.forEach(msg => { if (msg.role !== 'system') appendMessage(msg.role, msg.content); }); }
                function scrollToBottom() { chatHistoryEl.scrollTop(chatHistoryEl[0].scrollHeight); }


                // --- CORE SEND MESSAGE FUNCTION ---
                window.sendMessage = function () {
                    const userText = userInputEl.val().trim();
                    if (!userText) return;
                    
                    setInputState(true);
                    appendMessage('user', userText);
                    conversationHistory.push({ role: 'user', content: userText });
                    saveConversation();
                    userInputEl.val('');

                    const assistantMessageId = 'assistant-message-' + Date.now();
                    const typingIndicatorHTML = '<div class="typing-indicator"><span></span><span></span><span></span></div>';
                    chatHistoryEl.append($('<div>').addClass('message assistant').attr('id', assistantMessageId).html(typingIndicatorHTML));
                    scrollToBottom();

                    // --- START OF UPDATED LOGIC ---
                    // The old condition is removed. We now ONLY check if the switch is on.
                    if (apiSwitchEl.is(':checked')) {
                        // --- Kytisa RAG API Call ---
                        const kytisaProxyUrl = postData.rest_url + 'chatbot/v1/kytisa-query';
                        fetch(kytisaProxyUrl, {
                            method: 'POST',
                            headers: { 'Content-Type': 'application/json', 'X-WP-Nonce': postData.nonce },
                            body: JSON.stringify({ query: userText })
                        })
                        .then(response => {
                            if (!response.ok) return response.json().then(err => { throw new Error(err.message || 'Erreur du serveur.'); });
                            return response.json();
                        })
                        .then(jsonResponse => {
                            let assistantResponse = jsonResponse.answer || "Désolé, je n'ai pas pu extraire de réponse.";
                            if (jsonResponse.sources && (jsonResponse.sources.primary || (jsonResponse.sources.additional && jsonResponse.sources.additional.length > 0))) {
                                let sourcesHTML = "\n\n<hr>\n\n**Sources :**";
                                if (jsonResponse.sources.primary) {
                                    sourcesHTML += `\n* **Principale :** <a href="${jsonResponse.sources.primary}" target="_blank" rel="noopener noreferrer">${jsonResponse.sources.primary}</a>`;
                                }
                                if (jsonResponse.sources.additional && jsonResponse.sources.additional.length > 0) {
                                    sourcesHTML += "\n* **Additionnelles :**";
                                    jsonResponse.sources.additional.forEach(url => {
                                        sourcesHTML += `\n  * <a href="${url}" target="_blank" rel="noopener noreferrer">${url}</a>`;
                                    });
                                }
                                assistantResponse += sourcesHTML;
                            }
                            updateAssistantMessage(assistantMessageId, assistantResponse);
                            conversationHistory.push({ role: 'assistant', content: assistantResponse });
                            saveConversation();
                        })
                        .catch(error => {
                            console.error('Erreur Fetch API (Kytisa Proxy):', error);
                            updateAssistantMessage(assistantMessageId, `Désolé, une erreur est survenue: ${error.message}`);
                        })
                        .finally(() => setInputState(false));

                    } else {
                        // --- OpenRouter API Call ---
                        let messagesForApi = [createSystemPrompt(), ...conversationHistory];
                        const payload = { model: openRouterModel, messages: messagesForApi, stream: true };
                        let buffer = '';
                        fetch(openRouterApiUrl, {
                            method: 'POST',
                            headers: { 'Content-Type': 'application/json', 'Authorization': 'Bearer ' + openRouterApiKey },
                            body: JSON.stringify(payload)
                        }).then(response => {
                            if (!response.ok) throw new Error(`Erreur HTTP: ${response.status}`);
                            const reader = response.body.getReader();
                            const decoder = new TextDecoder();
                            
                            function push() {
                                reader.read().then(({ done, value }) => {
                                    if (done) {
                                        updateAssistantMessage(assistantMessageId, buffer);
                                        conversationHistory.push({ role: 'assistant', content: buffer });
                                        saveConversation();
                                        setInputState(false);
                                        return;
                                    }
                                    const chunk = decoder.decode(value, { stream: true });
                                    const lines = chunk.split('\n');
                                    lines.forEach(line => {
                                        if (line.startsWith('data: ')) {
                                            const jsonStr = line.slice(6).trim();
                                            if (jsonStr === '[DONE]') return;
                                            try {
                                                const token = JSON.parse(jsonStr).choices?.[0]?.delta?.content;
                                                if (token) buffer += token;
                                            } catch (e) { /* Incomplete JSON */ }
                                        }
                                    });
                                    updateAssistantMessage(assistantMessageId, buffer + '...');
                                    scrollToBottom();
                                    push();
                                }).catch(error => {
                                    console.error('Stream read error:', error);
                                    updateAssistantMessage(assistantMessageId, "Erreur de lecture de la réponse.");
                                    setInputState(false);
                                });
                            }
                            push();
                        }).catch(error => {
                            console.error('Fetch API Error (OpenRouter):', error);
                            updateAssistantMessage(assistantMessageId, `Désolé, une erreur de communication est survenue: ${error.message}`);
                            setInputState(false);
                        });
                    }
                    // --- END OF UPDATED LOGIC ---
                };

                // --- EVENT LISTENERS & INITIALIZATION ---
                chatToggleBtn.on('click', () => chatboxEl.toggleClass('visible'));
                sendBtn.on('click', sendMessage);
                userInputEl.on('keypress', e => {
                    if (e.which == 13 && !e.shiftKey) { e.preventDefault(); sendMessage(); }
                });

                clearChatBtn.on('click', () => clearChatModal.css('display', 'flex'));
                confirmCancelBtn.on('click', () => clearChatModal.hide());
                confirmOkBtn.on('click', () => {
                    conversationHistory = [createSystemPrompt()];
                    saveConversation();
                    displayConversationHistory();
                    appendSystemMessage("L'historique a été vidé.");
                    clearChatModal.hide();
                });

                apiSwitchEl.on('change', function() {
                    const isChecked = $(this).is(':checked');
                    localStorage.setItem(apiSwitchKey, JSON.stringify(isChecked));
                    const apiName = isChecked ? 'Kytisa LLM' : 'Kytisa Chat';
                    appendSystemMessage(`basculée sur : ${apiName}`);
                    conversationHistory[0] = createSystemPrompt(); // Update system prompt context
                    saveConversation();
                });

                // Initialize switch state
                let useKytisaApi = false; 
                try {
                    const storedState = localStorage.getItem(apiSwitchKey);
                    if (storedState !== null) useKytisaApi = JSON.parse(storedState);
                } catch(e) { /* ignore */ }
                apiSwitchEl.prop('checked', useKytisaApi);

                // Initialize chat on load
                displayConversationHistory();
                if (conversationHistory.length === 0) {
                    conversationHistory.push(createSystemPrompt());
                    appendSystemMessage("Bonjour ! Comment puis-je vous aider ?");
                    saveConversation();
                } else {
                     conversationHistory[0] = createSystemPrompt(); // Always update context on page load
                     saveConversation();
                }
            });
            </script>
            <?php
        });
    }
});