<?php
/**
 * Plugin Name: Custom Search Bar (Ctrl+F Like - Targeted)
 * Description: Adds a floating search bar with advanced Ctrl+F like functionality, targeting specific content.
 * Version: 1.5
 * Author: Your Name
 * Text Domain: custom-search-bar-assets
 */

// Prevent direct access to the file
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Enqueue all necessary scripts and styles for the custom search bar.
 */
function custom_search_bar_enqueue_assets() {
    // 1. Enqueue Tailwind CSS CDN (Optional - remove if your theme already provides utility classes)
    if ( ! wp_script_is( 'tailwind-cdn', 'enqueued' ) ) {
        wp_enqueue_script( 'tailwind-cdn', 'https://cdn.tailwindcss.com', array(), null, false );
    }

    // 2. Enqueue custom stylesheet (style.css)
    wp_enqueue_style(
        'custom-search-bar-styles',
        plugins_url( 'style.css', __FILE__ ),
        array(),
        filemtime( plugin_dir_path( __FILE__ ) . 'style.css' )
    );

    // 3. Enqueue custom JavaScript (script.js)
    wp_enqueue_script(
        'custom-search-bar-script',
        plugins_url( 'script.js', __FILE__ ),
        array(),
        filemtime( plugin_dir_path( __FILE__ ) . 'script.js' ),
        true
    );
}
add_action( 'wp_enqueue_scripts', 'custom_search_bar_enqueue_assets' );

/**
 * Shortcode function to output only the HTML structure of the search bar.
 */
function custom_search_bar_shortcode_html() {
    ob_start();
    ?>
    <div id="search-bar" class="fixed top-4 right-4 bg-white p-4 rounded-lg shadow-xl flex items-center space-x-3 z-50 transition-all duration-300 ease-in-out">
        <input type="text" id="search-input" placeholder="Find on page..." class="px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent w-48">
        <span id="match-count" class="text-sm text-gray-600 min-w-[50px] text-center">0/0</span>
        <button id="prev-button" class="p-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition-colors duration-200" title="Previous Match (Shift+Enter)">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z" clip-rule="evenodd" />
            </svg>
        </button>
        <button id="next-button" class="p-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition-colors duration-200" title="Next Match (Enter)">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
        <button id="close-button" class="p-2 bg-red-500 text-white rounded-md hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-opacity-50 transition-colors duration-200" title="Close Search">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode( 'custom_search_bar', 'custom_search_bar_shortcode_html' );