document.addEventListener('DOMContentLoaded', function () {
    const button = document.getElementById('popup-button');
    const popup = document.getElementById('popup');
    const overlay = document.getElementById('popup-overlay');
    const closeButton = document.getElementById('close-popup');
    const popupContent = document.getElementById('popup-content');
    const regenererButton = document.getElementById('Regenerer');

    if (button) {
        // Show popup and load content on the initial button click
        button.addEventListener('click', function (e) {
            e.preventDefault();

            // Show loading text while waiting for the response
            popupContent.innerHTML = '<p>Chargement du contenu...</p>';
            popup.style.display = 'block';
            overlay.style.display = 'block';

            // Fetch the post content via AJAX
            fetch(popupAjax.ajax_url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'load_post_content',  // Use the second function for initial fetch
                    post_id: popupAjax.post_id,
                }),
            })
                .then(response => response.text())
                .then(data => {
                    popupContent.innerHTML = data; // Insert content into the popup
                })
                .catch(error => {
                    console.error('Error:', error);
                    popupContent.innerHTML = '<p>Error loading content.</p>';
                });
        });
    }

    // Close popup
    closeButton.addEventListener('click', function () {
        popup.style.display = 'none';
        overlay.style.display = 'none';
    });

    // Close popup when clicking the overlay
    overlay.addEventListener('click', function () {
        popup.style.display = 'none';
        overlay.style.display = 'none';
    });

    // Regenerer button functionality
    if (regenererButton) {
        regenererButton.addEventListener('click', function (e) {
            e.preventDefault();

            // Show loading text while waiting for the second response
            popupContent.innerHTML = '<p>Regénération du contenu...</p>';

            // Fetch the post content via AJAX again, using load_post_content_ajax_2
            fetch(popupAjax.ajax_url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'load_post_content_2',  // Same action to regenerate content
                    post_id: popupAjax.post_id,
                }),
            })
                .then(response => response.text())
                .then(data => {
                    popupContent.innerHTML = data; // Insert updated content into the popup
                })
                .catch(error => {
                    console.error('Error:', error);
                    popupContent.innerHTML = '<p>Error regenerating content.</p>';
                });
        });
    }
});
