<?php
/**
 * Plugin Name: Guilaw Custom Functions
 * Plugin URI:  https://yourwebsite.com/
 * Description: A plugin to manage ACF and custom functions without modifying the Guilaw theme.
 * Version:     1.0
 * Author:      Your Name
 * Author URI:  https://yourwebsite.com/
 * License:     GPL2
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Include custom function files
include_once plugin_dir_path(__FILE__) . 'includes/acf-functions.php';
include_once plugin_dir_path(__FILE__) . 'includes/extra-functions.php';

// Plugin Activation Hook
function guilaw_custom_functions_activate() {
    // Optional: Actions on activation
}
register_activation_hook(__FILE__, 'guilaw_custom_functions_activate');

// Plugin Deactivation Hook
function guilaw_custom_functions_deactivate() {
    // Optional: Actions on deactivation
}
register_deactivation_hook(__FILE__, 'guilaw_custom_functions_deactivate');



// add mistral to dashbord
function guilaw_add_ocr_mistral_menu_page() {
    if (current_user_can('manage_options') || current_user_can('edit_others_posts')) {
        add_menu_page(
            'Ocr Mistral', // Page title
            'Ocr-mistral', // Menu title
            'edit_others_posts', // Minimum capability required
            'https://kytisa.com/ocr-pdf-to-docx/', // ✅ Direct link here
            null, // No callback needed
            'dashicons-media-code',
            6
        );
    }
}
add_action('admin_menu', 'guilaw_add_ocr_mistral_menu_page');

// add mistral to dashbord
function guilaw_add_auto_post() {
    if (current_user_can('manage_options') || current_user_can('edit_others_posts')) {
        add_menu_page(
            'Auto Post', // Page title
            'Auto-Post', // Menu title
            'edit_others_posts', // Minimum capability required
            'https://kytisa.com/filed.php', // ✅ Direct link here
            null, // No callback needed
            'dashicons-media-code',
            7
        );
    }
}
add_action('admin_menu', 'guilaw_add_auto_post');
