<?php
if (!defined('ABSPATH')) {
    exit;
}



// Function to display all ACF fields
function display_all_acf_fields() {
    if (function_exists('get_field_objects')) {
        $fields = get_field_objects();

        if ($fields) {
            echo '<div class="acf-fields">';
            
            foreach ($fields as $field_name => $field) {
                echo '<div class="acf-field">';
                echo '<strong>' . esc_html($field['label']) . ':</strong> ';

                if (empty($field['value'])) {
                    echo '<em>-</em>';
                } elseif (is_array($field['value'])) {
                    echo '<ul>';
                    foreach ($field['value'] as $item) {
                        echo '<li>' . esc_html($item) . '</li>';
                    }
                    echo '</ul>';
                } else {
                    echo esc_html($field['value']);
                }

                echo '</div>';
            }

            echo '</div>';
        } 
    }
}

// Function to add ACF fields after post content
function display_all_acf_fields_after_content($content) {
    if (is_singular('post')) { // Ensure it only runs on single posts
        ob_start();
        display_all_acf_fields();
        $acf_content = ob_get_clean();
        return $content . $acf_content; // Append ACF fields after the content
    }
    return $content;
}

// Hook to add ACF fields after content
add_action('the_content', 'display_all_acf_fields_after_content');






// Shortcode for AJAX Search Form
function custom_ajax_search_form() {
    $categories = get_categories([
        'hide_empty' => 0,
        'parent' => 0,
    ]);

    ob_start(); ?>
    <div id="search-wrapper">
        <form id="ajax-search-form" method="POST">
            <div class="form-group">
                <label for="s">Mot-clé:</label>
                <input type="text" id="s" name="s" placeholder="Recherche..." />
            </div>

            <div class="form-group">
                <label for="category">Catégorie:</label>
                <select id="category" name="cat">
                    <option value="">Toutes les catégories</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo esc_attr($category->term_id); ?>">
                            <?php echo esc_html($category->name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="subcategory">Sous-catégorie:</label>
                <select id="subcategory" name="subcat" disabled>
                    <option value=""> - </option>
                </select>
            </div>

            <div class="form-group">
                <label for="subsubcategory">Sous-sous-catégorie:</label>
                <select id="subsubcategory" name="subsubcat" disabled>
                    <option value=""> - </option>
                </select>
            </div>

            <button type="submit">Recherche</button>
            
            <button id="clear-search-storage" type="button">Effacer les résultats</button>

        </form>

        <div id="ajax-search-results"></div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('ajax_search_form', 'custom_ajax_search_form');


// AJAX handler for dynamic subcategories
function custom_get_subcategories() {
    $parent_id = intval($_POST['parent_id']);
    $subcategories = get_categories([
        'hide_empty' => 0,
        'parent' => $parent_id,
    ]);

    if (!empty($subcategories)) {
        echo '<option value=""> - </option>';
        foreach ($subcategories as $subcategory) {
            echo '<option value="' . esc_attr($subcategory->term_id) . '">' . esc_html($subcategory->name) . '</option>';
        }
    } else {
        echo '<option value="">Aucune sous-catégorie disponible</option>';
    }

    wp_die();
}
add_action('wp_ajax_get_subcategories', 'custom_get_subcategories');
add_action('wp_ajax_nopriv_get_subcategories', 'custom_get_subcategories');


// AJAX Search Handler
function custom_ajax_search_handler() {
    $keyword = sanitize_text_field($_POST['s'] ?? '');
    $cat = intval($_POST['cat'] ?? 0);
    $subcat = intval($_POST['subcat'] ?? 0);
    $subsubcat = intval($_POST['subsubcat'] ?? 0);

    $args = [
        's' => $keyword,
        'post_status' => 'publish',
        'posts_per_page' => -1,
    ];

    // Priority: subsubcat > subcat > cat
    if ($subsubcat) {
        $args['cat'] = $subsubcat;
    } elseif ($subcat) {
        $args['cat'] = $subcat;
    } elseif ($cat) {
        $args['cat'] = $cat;
    }

    $query = new WP_Query($args);

    echo '<p><strong>' . $query->found_posts . ' résultat(s) trouvé(s).</strong></p>';

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            echo '<div class="search-result-item">';
            echo '<h3><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></h3>';
            echo '<p>' . esc_html(get_the_excerpt()) . '</p>';
            echo '</div>';
        }
    } else {
        echo '<p>Aucun résultat trouvé.</p>';
    }

    wp_reset_postdata();
    wp_die();
}
add_action('wp_ajax_custom_ajax_search', 'custom_ajax_search_handler');
add_action('wp_ajax_nopriv_custom_ajax_search', 'custom_ajax_search_handler');


// Enqueue JavaScript
function enqueue_ajax_search_scripts() {
    wp_enqueue_script('ajax-search', plugin_dir_url(__DIR__) .  '/assets/js/ajax-search.js', ['jquery'], null, true);
    wp_localize_script('ajax-search', 'ajaxsearch', [
        'ajaxurl' => admin_url('admin-ajax.php'),
    ]);
}
add_action('wp_enqueue_scripts', 'enqueue_ajax_search_scripts');


// Register Shortcodes for "Print / Save as PDF" and "Download Post as Word"
function register_post_buttons_shortcode() {
    add_shortcode('post_buttons', 'display_post_buttons');
}
add_action('init', 'register_post_buttons_shortcode');

// Display Print and Word Export Buttons
function display_post_buttons($atts) {
    ob_start(); ?>
    
  
    <div class="post-buttons" id="popup-dev">
        
        
                <form method="POST" action="<?php echo esc_url(add_query_arg('export_post_pdf', get_the_ID())); ?>">
            <input id="printButton" style="display: block; background: #0073aa; color: white; border: none; cursor: pointer;" type="submit" name="export_post_pdf" value="Télécharger PDF Format" class="button button-primary"/>
        </form>
        
    
        
         <!-- Download Post as Word Button -->
        <form method="POST" action="<?php echo esc_url(add_query_arg('export_post', get_the_ID())); ?>">
            <input id="wordButton" type="submit" name="export_post" value="Télécharger Word Format" class="button button-primary"/>
        </form>
		
		<a href="#" id="popup-button" class="custom-button">Résumé IA</a>
    </div>

    <?php
    return ob_get_clean();
}


// Handle Word Export Request
add_action('template_redirect', 'handle_post_export');

function handle_post_export() {
    if (isset($_GET['export_post'])) {
        $post_id = intval($_GET['export_post']);

        if ($post_id > 0) {
            export_post_to_word($post_id);
        }
    }
    
        if (isset($_GET['export_post_pdf'])) {
        $post_id = intval($_GET['export_post_pdf']);

        if ($post_id > 0) {
            export_post_to_pdf($post_id);
        }
    }
    
    
    
    
    
}
//////////////////////////////// Function to export the post to Word format


function export_post_to_word($post_id) {
    $post = get_post($post_id);

    if (!$post) {
        return;
    }

    // Start Word document content with A4 page size
    $content = "<html xmlns:w='urn:schemas-microsoft-com:office:word'><head>";
    $content .= "<style>";
    $content .= "@page { size: 21cm 29.7cm; margin: 2cm; }";
    $content .= "div.header { position: running(header); }";
    $content .= "@page { @top-center { content: element(header); } }";
    $content .= "</style>";
    $content .= "</head><body>";

    // Add header with post title
    $content .= '<div class="header">';
    $content .= "<h1>" . esc_html(get_the_title($post)) . "</h1>";
    $content .= '</div>';

    // Add post content without "post-buttons" div
$post_content_filtered = apply_filters('the_content', $post->post_content);

// Remove <div class="post-buttons">...</div>
$post_content_filtered = preg_replace(
    '/<div[^>]*class="post-buttons"[^>]*>.*?<\/div>/is',
    '',
    $post_content_filtered
);

// Remove any element with class="count"
$post_content_filtered = preg_replace(
    '/<[^>]*class="[^"]*\bcount\b[^"]*"[^>]*>.*?<\/[^>]+>/is',
    '',
    $post_content_filtered
);

$content .= $post_content_filtered;



    // Optional footer
    $content .= '<br><div class="footer"></div>';
    $content .= "</body></html>";

    // Save HTML content
    $html_path = ABSPATH . 'scrpto/ocr.html';
    file_put_contents($html_path, $content);

    // DOCX filename
       $docx_filename = sanitize_title(get_the_title($post)) . "_ocr.docx";
   $script_path = ABSPATH . 'scrpto/';
$output_path = $script_path . $docx_filename;

$command = "source " . $script_path . "bin/activate && cd " . $script_path . " && python3 hello.py " . escapeshellarg($docx_filename);

    
    
    // Run the command
    $output = shell_exec($command);
    $generated_filename = trim(urldecode($output));

    // Full path to file
    $file_path = ABSPATH . 'scrpto/' . $generated_filename;

    if (file_exists($file_path)) {
        // Set headers to force download or display based on browser
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
        header('Content-Disposition: attachment; filename="' . basename($generated_filename) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file_path));

        // Clear output buffer to avoid corruption
        ob_clean();
        flush();
        readfile($file_path);
        
        unlink($file_path);
        
        exit;
    } 
}


function export_post_to_pdf($post_id, $force_download = true) {
    $post = get_post($post_id);

    if (!$post) {
        return;
    }

    // Load TCPDF
    require_once ABSPATH . 'pdf/vendor/autoload.php';


    class PDFWithHeaderFooter extends TCPDF {
        public function Header() {
            // Add your custom header text
            $this->SetFont('helvetica', 'B', 12);
            $this->SetTextColor(0, 0, 0);
            $this->Cell(0, 10, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');

            // Add image to the header
            $image_url = site_url('/wp-content/uploads/2025/05/kytisa-header.jpg');

            $this->Image($image_url, 8, 8, 170); // Position and size the image as needed

            // Add watermark on each page
            $this->SetAlpha(0.3);
            $this->SetFont('helvetica', 'B', 50);
            $this->SetTextColor(192, 192, 192);
            $this->StartTransform();
            $this->Rotate(45, $this->getPageWidth() / 2, $this->getPageHeight() / 2);
            $this->Text($this->getPageWidth() / 4, $this->getPageHeight() / 2, 'KYTISA.COM');
            $this->StopTransform();
            $this->SetAlpha(1);
        }

        public function Footer() {
            // Add image to the footer
$image_url = site_url('/wp-content/uploads/2025/05/kytisa-header.jpg');

            $this->Image($image_url, 10, $this->getPageHeight() - 20, 170); // Position and size the image as needed

            $this->SetY(-15);
            $this->SetFont('helvetica', 'I', 10);
            // Add your custom footer text
            $this->Cell(0, 10, '', 0, false, 'L', 0, '', 0, false, 'M', 'M');
            // Add page numbers centered
            $this->Cell(0, 20, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(),
                0, false, 'C', 0, '', 0, false, 'M', 'M');
        }
    }

    // Create PDF
    $pdf = new PDFWithHeaderFooter(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetCreator('Your Name');
    $pdf->SetAuthor('Your Name');
    $pdf->SetTitle(get_the_title($post));

    $pdf->SetMargins(15, 27, 15);
    $pdf->SetHeaderMargin(10);
    $pdf->SetFooterMargin(15);
    $pdf->SetAutoPageBreak(TRUE, 25);
    $pdf->SetFont('dejavusans', '', 12);
    $pdf->AddPage();

    // Get content and keep <a href="..."> intact
    $post_content = apply_filters('the_content', $post->post_content);

    // Remove unwanted divs like post-buttons
$post_content_cleaned = preg_replace(
    [
        '/<div[^>]*class="post-buttons"[^>]*>.*?<\/div>/is',
        '/<[^>]*class="count"[^>]*>.*?<\/[^>]+>/is'
    ],
    '',
    $post_content
);


    // Sanitize and allow links and basic HTML
    $allowed_tags = [
        'a' => ['href' => [], 'target' => [], 'rel' => []],
        'p' => [], 'br' => [], 'ul' => [], 'ol' => [], 'li' => [],
        'strong' => [], 'em' => [], 'b' => [], 'i' => [], 'u' => [],
        'h1' => [], 'h2' => [], 'h3' => [], 'h4' => [], 'h5' => [], 'h6' => [],
    ];

    // Start building HTML
    $html = "<h1>" . esc_html(get_the_title($post)) . "</h1>";
    $html .= $post_content_cleaned;

    // Write content to PDF
    $pdf->writeHTML($html, true, false, true, false, '');

    // Prepare file name
    $filename = sanitize_title(get_the_title($post)) . '.pdf';

    // Set headers
    header('Content-Type: application/pdf');
    header('Content-Disposition: ' . ($force_download ? 'attachment' : 'inline') . '; filename="' . $filename . '"');
    header('Cache-Control: private, max-age=0, must-revalidate');
    header('Pragma: public');

    // Output PDF
    $pdf->Output($filename, $force_download ? 'D' : 'I');
}



////////////////Js script  /////////////

function enqueue_popup_scripts() {
if (is_single()) {
       // Enqueue the custom script from the plugin directory
    wp_enqueue_script('popup-script', plugin_dir_url(__DIR__) . 'assets/js/popup.js', array('jquery'), null, true);

    // Localize script for AJAX
    wp_localize_script('popup-script', 'popupAjax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'post_id'  => get_the_ID(),
    ));
}
}
add_action('wp_enqueue_scripts', 'enqueue_popup_scripts');

function load_post_content_ajax() {
    // Check if the post_id is provided in the AJAX request
    if (isset($_POST['post_id'])) {
        $post_id = intval($_POST['post_id']);
        $post = get_post($post_id);
        
        // Check if the post exists and is published
        if ($post && $post->post_status === 'publish') {
            
            global $wpdb;
            $table_name = $wpdb->prefix . 'posts';
            
            // Check if the 'gpt' column exists in the database, if not, add it
            $column_exists = $wpdb->get_results("SHOW COLUMNS FROM `$table_name` LIKE 'gpt'");
            if (empty($column_exists)) {
                // Add the 'gpt' column if it doesn't exist
                $wpdb->query("ALTER TABLE `$table_name` ADD `gpt` LONGTEXT NOT NULL");
            }

            // Retrieve the 'gpt' column value for the current post
            $gpt_content = $wpdb->get_var($wpdb->prepare(
                "SELECT gpt FROM `$table_name` WHERE ID = %d",
                $post_id
            ));

            // If 'gpt' column is not empty, return the stored response
            if (!empty($gpt_content)) {
                echo $gpt_content; // Return the stored GPT content
            } else {

                // Get the categories of the current post
                $categories = get_the_category($post_id);
                $category_names = wp_list_pluck($categories, 'name');
                
                // Check if the post has one of the specific categories
                if (in_array('JURISPRUDENCES GUINEE', $category_names) || in_array('JURISPRUDENCES CCJA OHADA', $category_names)|| in_array('JURISPRUDENCES CEDEAO', $category_names)) {
                    // Use 'gpt_custom_prompt_1' for these categories
                    $prompt = get_option('gpt_custom_prompt_2', '') . wpautop($post->post_content);
                } else {
                    // Use 'gpt_custom_prompt_2' for all other categories
                    $prompt = get_option('gpt_custom_prompt_1', '') . wpautop($post->post_content);
                }

                // Query the Perplexity API to get the response
                $api_key = get_option('gpt_api_key', ''); // Replace with a securely stored API key
                $messageResponse = queryMistralAPI($prompt, $api_key);

                // Check if the API request was successful and response is valid
                if ($messageResponse === "API Error") {
                    echo 'API request failed. Please try again.';
                    wp_die();
                }

                // If API response is valid, update the 'gpt' column with the API response
                if (!empty($messageResponse)) {
                    $update_result = $wpdb->update(
                        $table_name,
                        ['gpt' => $messageResponse], // The new content for the 'gpt' column
                        ['ID' => $post_id], // Target the specific post
                        ['%s'], // Format for the content
                        ['%d'] // Format for the post ID
                    );

                    // Check if the update was successful
                    if ($update_result === false) {
                        echo 'Failed to update the post with the generated content.';
                    } else {
                        // Return the API response (short description) to the frontend
                        echo $messageResponse;
                    }
                } else {
                    echo 'API response is empty. Please try again.';
                }
            }

        } else {
            echo 'Content not available.';
        }
    } else {
        echo 'Post ID is missing.';
    }

    wp_die(); // Properly end the AJAX request
}


add_action('wp_ajax_load_post_content', 'load_post_content_ajax');
add_action('wp_ajax_nopriv_load_post_content', 'load_post_content_ajax');


function load_post_content_ajax_2() {
    // Check if the post_id is provided in the AJAX request
    if (isset($_POST['post_id'])) {
        $post_id = intval($_POST['post_id']);
        $post = get_post($post_id);
        
        // Check if the post exists and is published
        if ($post && $post->post_status === 'publish') {
            
            global $wpdb;
            $table_name = $wpdb->prefix . 'posts';
            
            // Check if the 'gpt' column exists in the database, if not, add it
            $column_exists = $wpdb->get_results("SHOW COLUMNS FROM `$table_name` LIKE 'gpt'");
            if (empty($column_exists)) {
                // Add the 'gpt' column if it doesn't exist
                $wpdb->query("ALTER TABLE `$table_name` ADD `gpt` LONGTEXT NOT NULL");
            }

            // Retrieve the 'gpt' column value for the current post
            $gpt_content = $wpdb->get_var($wpdb->prepare(
                "SELECT gpt FROM `$table_name` WHERE ID = %d",
                $post_id
            ));



                // Get the categories of the current post
                $categories = get_the_category($post_id);
                $category_names = wp_list_pluck($categories, 'name');
                
                // Check if the post has one of the specific categories
                if (in_array('JURISPRUDENCES GUINEE', $category_names) || in_array('JURISPRUDENCES CCJA OHADA', $category_names)|| in_array('JURISPRUDENCES CEDEAO', $category_names)) {
                    // Use 'gpt_custom_prompt_1' for these categories
                    $prompt =  get_option('gpt_custom_prompt_2', '') . wpautop($post->post_content) . "note : give the same reponse of api";
                } else {
                    // Use 'gpt_custom_prompt_2' for all other categories
                    $prompt = get_option('gpt_custom_prompt_1', '') . wpautop($post->post_content);
                }

                // Query the Perplexity API to get the response
                $api_key = get_option('gpt_api_key', ''); // Replace with a securely stored API key
                $messageResponse = queryMistralAPI($prompt, $api_key);

                // Check if the API request was successful and response is valid
                if ($messageResponse === "API Error") {
                    echo 'API request failed. Please try again.';
                    wp_die();
                }

                // If API response is valid, update the 'gpt' column with the API response
                if (!empty($messageResponse)) {
                    $update_result = $wpdb->update(
                        $table_name,
                        ['gpt' => $messageResponse], // The new content for the 'gpt' column
                        ['ID' => $post_id], // Target the specific post
                        ['%s'], // Format for the content
                        ['%d'] // Format for the post ID
                    );

                    // Check if the update was successful
                    if ($update_result === false) {
                        echo 'Failed to update the post with the generated content.';
                    } else {
                        // Return the API response (short description) to the frontend
                        echo $messageResponse;
                    }
                } else {
                    echo 'API response is empty. Please try again.';
                }
            

        } else {
            echo 'Content not available.';
        }
    } else {
        echo 'Post ID is missing.';
    }

    wp_die(); // Properly end the AJAX request
}


add_action('wp_ajax_load_post_content_2', 'load_post_content_ajax_2');
add_action('wp_ajax_nopriv_load_post_content_2', 'load_post_content_ajax_2');


function add_popup_button_after_post_title($title, $id = null) {
    if (is_single() && in_the_loop() && is_main_query()) {
       // $button_html = '<a href="#" id="popup-button" class="custom-button">Afficher le résumé IA</a>';
        $popup_html = '
            <div id="popup" style="display:none; position:fixed; top:50%; left:50%; transform:translate(-50%, -50%); background:white; padding:20px; border:1px solid #ccc; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1); z-index:1000; max-width:600px; overflow-y:auto;">
                <p id="popup-content"></p>
                <div class="m">
                <button id="close-popup" style="margin-top:10px;">Fermer</button>
                <button id="Regenerer" style="margin-top:10px;">Regenerer</button></div>
            </div> 
            <div id="popup-overlay" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:999;"></div>
        ';
        return $title . ' ' . $button_html . $popup_html;
    }
    return $title;
}



//add_filter('the_title', 'add_popup_button_after_post_title', 10, 2);

// Step 1: Add custom user meta field to the user profile page
function add_show_button_field_to_user_profile($user) {
    if (current_user_can('administrator')) { // Check if the current user is an admin
        ?>
        <table class="form-table">
            <tr>
                <th><label for="show_button"><?php _e("Afficher le résumé IA"); ?></label></th>
                <td>
                    <select name="show_button" id="show_button">
                        <option value="yes" <?php echo (get_user_meta($user->ID, 'show_button', true) == 'yes') ? 'selected' : ''; ?>>Oui</option>
                        <option value="no" <?php echo (get_user_meta($user->ID, 'show_button', true) == 'no') ? 'selected' : ''; ?>>Non</option>
                    </select>
                </td>
            </tr>
        </table>
        <?php
    }
}

add_action('show_user_profile', 'add_show_button_field_to_user_profile');
add_action('edit_user_profile', 'add_show_button_field_to_user_profile');

// Save the custom field value
function save_show_button_field($user_id) {
    if (isset($_POST['show_button'])) {
        update_user_meta($user_id, 'show_button', $_POST['show_button']);
    }
}
add_action('personal_options_update', 'save_show_button_field');
add_action('edit_user_profile_update', 'save_show_button_field');

// Step 2: Conditionally remove the button filter based on the user's 'show_button' setting
function conditional_add_popup_button_after_post_title($title, $post_id) {
    $user_id = get_current_user_id();
    $show_button = get_user_meta($user_id, 'show_button', true);

    // Check if the 'show_button' value is 'yes', only then add the button
    if ($show_button === 'yes') {
       add_filter('the_title', 'add_popup_button_after_post_title', 10, 2);
    }

    return $title;
}




// Only add the filter if the user has 'show_button' set to 'yes'
function add_filter_for_show_button() {
    $user_id = get_current_user_id();
    $show_button = get_user_meta($user_id, 'show_button', true);

    if ($show_button === 'yes') {
        add_filter('the_title', 'conditional_add_popup_button_after_post_title', 10, 2);
    } else {
        remove_filter('the_title', 'conditional_add_popup_button_after_post_title', 10);
        
        // Add JavaScript to hide the element with specific ID when the button is not shown
        add_action('wp_footer', function() {
            echo '<script>
                    var element = document.getElementById("popup-button");
                    if (element) {
                        element.style.display = "none";
                    }
                  </script>';
        });
    }
}

add_action('template_redirect', 'add_filter_for_show_button');



/////////////////guest//////////////////



/////////////////////////////////////////////////////////////////////////

// Add Download Count field to user profile
function add_download_count_field($user) {
    ?>
    <h3>Statistiques de téléchargement</h3>
    <table class="form-table">
        <tr>
            <th><label for="download_count">Nombre de téléchargements</label></th>
            <td>
                <input type="number" name="download_count" value="<?php echo get_user_meta($user->ID, 'download_count', true) ?: 0; ?>" readonly />
            </td>
        </tr>
    </table>
    <?php
}
add_action('show_user_profile', 'add_download_count_field');
add_action('edit_user_profile', 'add_download_count_field');

// Function to update download count only for subscribers
function track_download_count() {
    if (is_user_logged_in()) {
        $user = wp_get_current_user();
        
        // Check if user has the 'subscriber' role
        if (in_array('subscriber', (array) $user->roles)) {
            $user_id = $user->ID;
            $count = get_user_meta($user_id, 'download_count', true) ?: 0;
            update_user_meta($user_id, 'download_count', $count + 1);
            wp_send_json_success(['count' => $count + 1]);
        } else {
            wp_send_json_error(['message' => 'Access denied: Only subscribers can download']);
        }
    } else {
        wp_send_json_error(['message' => 'User not logged in']);
    }
}
add_action('wp_ajax_track_download', 'track_download_count');


// JavaScript to track button clicks for both buttons
function download_tracking_script() {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        let buttons = ["printButton", "wordButton"];
        
        buttons.forEach(function(id) {
            let button = document.getElementById(id);
            if (button) {
                button.addEventListener("click", function() {
                    let xhr = new XMLHttpRequest();
                    xhr.open("POST", "<?php echo admin_url('admin-ajax.php'); ?>", true);
                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    xhr.send("action=track_download");
                });
            }
        });
    });
    </script>
    <?php
}
add_action('wp_footer', 'download_tracking_script');




///////////////////////Add buttons to post /////////////////////////////////

/*
		
function register_post_buttons($content) {
	
	
    if (is_singular('post')) {
		
		        $user_id = get_current_user_id();
        $count = get_user_meta($user_id, 'download_count', true) ?: 0;
	//////////////////number of telechargement /////////////////	
		if ($count <= get_option('get_download_nbr', '')) {
    $buttons =  do_shortcode('[post_buttons]'); // Corrected: removed echo
		// $button_html = '<a href="#" id="popup-button" class="custom-button">Afficher le résumé de l'IA</a>';
        $content = $count .  $buttons  . $content  ; // Prepend buttons to content
} else {
			
			       

   $content = $content  ;
}   
		
    }
    return $content;
}


add_filter('the_content', 'register_post_buttons');
 
*/


//////////////cron//


// Schedule the event if it is not already scheduled
function custom_schedule_download_count_update() {
    if (!wp_next_scheduled('update_user_download_count_cron')) {
        wp_schedule_event(strtotime('next Sunday midnight'), 'weekly', 'update_user_download_count_cron');
    }
}
add_action('wp', 'custom_schedule_download_count_update');

// Hook into the scheduled event
add_action('update_user_download_count_cron', 'update_download_count');

function update_download_count() {
    // Get all users
    $users = get_users(array('fields' => 'ID'));

    foreach ($users as $user_id) {
        $count = get_user_meta($user_id, 'download_count', true);
        $count = (int)$count; // Ensure it's an integer
        update_user_meta($user_id, 'download_count', 0);
    }
}



////////////////////////////////////////////////////////////////////////////////

function unlock_post_for_admins($post_ID, $post) {
    // Check if the current user is an editor and the post is being published
    if (current_user_can('editor') && $post->post_status == 'publish') {
        // Remove post lock to allow admins to edit freely
        delete_post_meta($post_ID, '_edit_lock');
        delete_post_meta($post_ID, '_edit_last'); // Remove last editor data
        
        // Change post ownership to an admin (Replace 'admin' with actual admin username)
        $admin_user = get_user_by('login', 'admin');
        if ($admin_user) {
            wp_update_post(array(
                'ID'          => $post_ID,
                'post_author' => $admin_user->ID
            ));
        }
    }
}
add_action('publish_post', 'unlock_post_for_admins', 10, 2);

// Forcefully remove locks when admins access the post editor
function force_remove_edit_lock($post_ID) {
    if (current_user_can('administrator')) {
        delete_post_meta($post_ID, '_edit_lock');
        delete_post_meta($post_ID, '_edit_last');
    }
}
add_action('load-post.php', function() {
    if (isset($_GET['post'])) {
        force_remove_edit_lock(intval($_GET['post']));
    }
});



///////////////////////////////// Disable Right Click For WordPress///////////////
function disable_right_click_and_copy() {
    if (!current_user_can('manage_options')) { // Exclude admin users
        echo '<script>
            document.addEventListener("contextmenu", function(e) {
                e.preventDefault();
            });
            document.addEventListener("selectstart", function(e) {
                e.preventDefault();
            });
            document.addEventListener("copy", function(e) {
                e.preventDefault();
            });
        </script>';
    }
}
add_action("wp_head", "disable_right_click_and_copy");



//////////////////////Desable account /////////////////////////// 
// Ajouter un champ personnalisé pour désactiver le compte après un délai spécifié dans la page du profil de l'utilisateur dans l'admin WordPress
function add_disable_account_time_field($user) {
    // Vérifier si l'utilisateur actuel a la capacité nécessaire (administrateur)
    if (current_user_can('administrator')) {
        // Obtenir le délai après lequel le compte doit être désactivé
        $disable_after_time = get_user_meta($user->ID, 'disable_account_after', true);
        ?>
        <h3><?php _e("Paramètres de désactivation du compte", "profile"); ?></h3>

        <table class="form-table">
            <tr>
                <th><label for="disable_account_time"><?php _e("Désactiver le compte après", "profile"); ?></label></th>
                <td>
                    <select name="disable_account_time" id="disable_account_time">
                        <option value="0" <?php selected($disable_after_time, 0); ?>><?php _e('Ne pas désactiver'); ?></option>
                        <option value="120" <?php selected($disable_after_time, 120); ?>><?php _e('Désactiver après 2 minutes'); ?></option>
                        <option value="900" <?php selected($disable_after_time, 900); ?>><?php _e('Désactiver après 15 minutes'); ?></option>
                        <option value="604800" <?php selected($disable_after_time, 604800); ?>><?php _e('Désactiver après 1 semaine'); ?></option>
                        <option value="2592000" <?php selected($disable_after_time, 2592000); ?>><?php _e('Désactiver après 1 mois'); ?></option>
                        <option value="5184000" <?php selected($disable_after_time, 5184000); ?>><?php _e('Désactiver après 2 mois'); ?></option>
                        <option value="7776000" <?php selected($disable_after_time, 7776000); ?>><?php _e('Désactiver après 3 mois'); ?></option>
                        <option value="15552000" <?php selected($disable_after_time, 15552000); ?>><?php _e('Désactiver après 6 mois'); ?></option>
                        <option value="31536000" <?php selected($disable_after_time, 31536000); ?>><?php _e('Désactiver après 12 mois'); ?></option>
                    </select>
                    <span class="description"><?php _e("Sélectionnez le délai après lequel le compte doit être désactivé."); ?></span>
                </td>
            </tr>
        </table>
        <?php
    }
}
add_action('show_user_profile', 'add_disable_account_time_field');
add_action('edit_user_profile', 'add_disable_account_time_field');

// Sauvegarder le délai sélectionné lorsque le profil de l'utilisateur est sauvegardé
function save_disable_account_time_field($user_id) {
    // Vérifier si l'utilisateur actuel est un administrateur
    if (!current_user_can('administrator', $user_id)) {
        return;
    }

    // Sauvegarder le délai après lequel le compte doit être désactivé (en secondes)
    if (isset($_POST['disable_account_time'])) {
        update_user_meta($user_id, 'disable_account_after', sanitize_text_field($_POST['disable_account_time']));
    }
}
add_action('personal_options_update', 'save_disable_account_time_field');
add_action('edit_user_profile_update', 'save_disable_account_time_field');

// Déconnecter automatiquement un utilisateur si son compte est désactivé après le délai sélectionné
function check_user_disabled_account_time() {
    // Obtenir l'utilisateur actuel
    $user = wp_get_current_user();

    // Si l'utilisateur est connecté et a un délai pour désactiver le compte
    if (is_user_logged_in()) {
        // Obtenir le délai "disable_account_after" de l'utilisateur (en secondes)
        $disable_after_time = get_user_meta($user->ID, 'disable_account_after', true);

        if ($disable_after_time > 0) {
            // Obtenir le temps auquel le compte doit être désactivé (stocké dans les métadonnées de l'utilisateur)
            $disable_time = get_user_meta($user->ID, 'disable_account_time', true);

            // Si aucun temps de désactivation n'est défini, l'initialiser avec le temps actuel + le délai sélectionné
            if (!$disable_time) {
                update_user_meta($user->ID, 'disable_account_time', time() + $disable_after_time);
            }

            // Vérifier si l'heure actuelle a dépassé le temps de désactivation
            if (time() >= $disable_time) {
                // Désactiver le compte en déconnectant l'utilisateur et en le redirigeant
                wp_logout();
                wp_redirect(home_url());
                exit; // S'assurer que le script s'arrête après la déconnexion et la redirection
            }
        }
    }
}
add_action('init', 'check_user_disabled_account_time');

// Empêcher la connexion si le compte est désactivé après le délai spécifié
function prevent_disabled_account_time_login($user_login, $user) {
    // Obtenir le délai "disable_account_after" de l'utilisateur
    $disable_after_time = get_user_meta($user->ID, 'disable_account_after', true);

    if ($disable_after_time > 0) {
        // Obtenir le temps auquel le compte doit être désactivé
        $disable_time = get_user_meta($user->ID, 'disable_account_time', true);

        // Si aucun temps de désactivation n'est défini, l'initialiser avec le temps actuel + le délai sélectionné
        if (!$disable_time) {
            update_user_meta($user->ID, 'disable_account_time', time() + $disable_after_time);
        }

        // Vérifier si l'heure actuelle a dépassé le temps de désactivation
        if (time() >= $disable_time) {
            wp_logout();
            wp_die(__('Votre compte est désactivé en raison de l\'inactivité. Veuillez contacter l\'administrateur.'));
        }
    }
}
add_action('wp_login', 'prevent_disabled_account_time_login', 10, 2);









//////////////////////////////////////run update gpt collumn//////////////////////
function queryMistralAPI($prompt, $apiKey) {
    $url = "https://api.mistral.ai/v1/chat/completions"; // Correct API endpoint

    $data = [
        "model" => "mistral-large-latest",
        "temperature" => 0.6,
        "top_p" => 1,
        "stream" => false,
        "messages" => [
            ["role" => "user", "content" => $prompt]
        ],
        "response_format" => ["type" => "text"],
        "presence_penalty" => 0,
        "frequency_penalty" => 0,
        "n" => 1
    ];

    $headers = [
        "Authorization: Bearer " . $apiKey,
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get HTTP status code
    $curl_error = curl_error($ch); // Get any cURL errors
    curl_close($ch);

    if ($http_code !== 200) {
        return "API Error";
    }

    $decodedResponse = json_decode($response, true);
    
    // Check if response contains choices and message content
    $content = $decodedResponse['choices'][0]['message']['content'] ?? "No valid response received.";

    // Format the response as a web-friendly HTML article
    return formatArticleAsHTML($content);
}

function formatArticleAsHTML($content) {
    // Replace Markdown-style headings and bold text with appropriate HTML tags
    $content = preg_replace('/#### (.*?)\n/', '<h4>$1</h4>', $content); // Convert #### to <h4>
    $content = preg_replace('/### (.*?)\n/', '<h3>$1</h3>', $content); // Convert ### to <h3>
    $content = preg_replace('/\*\*(.*?)\*\*/', '<strong>$1</strong>', $content); // Convert **bold** to <strong>
    $content = preg_replace('/\n/', '<p>$0</p>', $content); // Wrap new lines in <p> tags
    
    return "<article>$content</article>";
}


// Add a custom admin page for running the update process
function my_custom_admin_menu() {
    add_menu_page(
        'GPT Update',               // Page title
        'GPT Update',               // Menu title
        'manage_options',           // Capability required to access the page
        'gpt-update',               // Menu slug
        'gpt_update_page',          // Function to display the page content
        'dashicons-update',         // Icon for the menu item
        30                          // Position in the menu
    );
}
add_action('admin_menu', 'my_custom_admin_menu');

// Display the admin page content
function gpt_update_page() {
    global $wpdb;
    
    $categories = get_categories(['hide_empty' => false]);
    $saved_api_key = get_option('gpt_api_key', '');
    $download_nbr = get_option('get_download_nbr', '');
    
    if (isset($_POST['save_api_key'])) {
        update_option('gpt_api_key', sanitize_text_field($_POST['api_key']));
        $saved_api_key = sanitize_text_field($_POST['api_key']);
        echo '<div class="updated"><p>API Key saved successfully!</p></div>';
    }

    // Save individual prompts for each textarea
    if (isset($_POST['save_custom_prompt_1'])) {
        update_option('gpt_custom_prompt_1', sanitize_text_field($_POST['custom_prompt_1']));
        echo '<div class="updated"><p>Prompt 1 saved successfully!</p></div>';
    }
    if (isset($_POST['save_custom_prompt_2'])) {
        update_option('gpt_custom_prompt_2', sanitize_text_field($_POST['custom_prompt_2']));
        echo '<div class="updated"><p>Prompt 2 saved successfully!</p></div>';
    }
    if (isset($_POST['save_custom_prompt_3'])) {
        update_option('gpt_custom_prompt_3', sanitize_text_field($_POST['custom_prompt_3']));
        echo '<div class="updated"><p>Prompt 3 saved successfully!</p></div>';
    }
    
    
        if (isset($_POST['save_download_nbr'])) {
        update_option('get_download_nbr', sanitize_text_field($_POST['download_nbr']));
        $save_download_nbr = sanitize_text_field($_POST['download_nbr']);
        echo '<div class="updated"><p>Numbre de telechargement sauvgarder!</p></div>';
    }


    // Run GPT Update for the selected category and active textarea
    if (isset($_POST['run_gpt_update'])) {
        $category_id = intval($_POST['category']);
        $active_textarea = sanitize_text_field($_POST['active_textarea']);
        $custom_prompt = sanitize_text_field($_POST[$active_textarea]);
        gpt_update_all_posts($category_id, $custom_prompt, $saved_api_key);
    }
    ?>
    <div class="wrap">
        <h1>Mise à jour des réponses GPT pour les articles</h1><br>
        
        <form method="post">
            <label for="api_key">API Key:</label>
            <input type="text" name="api_key" id="api_key" value="<?php echo esc_attr($saved_api_key); ?>" required />
            <input type="submit" name="save_api_key" value="Save API Key" class="button button-secondary" />
        </form>
        <br><br>

        <form method="post">
            <label for="category">Sélectionnez une catégorie:</label><br>
            <select name="category" id="category" required>
                <option value="">-- Sélectionner une catégorie --</option>
                <?php foreach ($categories as $category) : ?>
                    <option value="<?php echo esc_attr($category->term_id); ?>">
                        <?php echo esc_html($category->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <br><br>
            
            <!-- Add checkboxes and textareas for active selection -->
            <div>
                <input type="radio" name="active_textarea" value="custom_prompt_1" id="custom_prompt_1" />
                <label for="custom_prompt_1">Géneral Prompt</label><br>
                <textarea name="custom_prompt_1" id="custom_prompt_1" rows="4" cols="50"><?php echo get_option('gpt_custom_prompt_1', ''); ?></textarea><br>
                <input type="submit" name="save_custom_prompt_1" value="Save" class="button button-secondary" /><br><br>                                                                                                                                             
                
                <input type="radio" name="active_textarea" value="custom_prompt_2" id="custom_prompt_2" />
                <label for="custom_prompt_2">Jurisprudence Prompt</label><br>
                <textarea name="custom_prompt_2" id="custom_prompt_2" rows="4" cols="50"><?php echo get_option('gpt_custom_prompt_2', ''); ?></textarea><br>
                <input type="submit" name="save_custom_prompt_2" value="Save" class="button button-secondary" /><br><br>

                

            </div>

            <br><br>
            <input type="submit" name="run_gpt_update" value="Run GPT Update" class="button button-primary" />
        </form>
        
        <br><br>
         <form method="post">
            <label for="download_nbr">Nombre de telechargement :</label>
            <input type="text" name="download_nbr" id="download_nbr" value="<?php echo esc_attr($download_nbr); ?>" required />
            <input type="submit" name="save_download_nbr" value="Save" class="button button-secondary" />
        </form>
        
    </div>
    <?php
}

// Function to update all posts in the selected category
function gpt_update_all_posts($category_id, $custom_prompt, $apiKey) {
    global $wpdb;
    
    $posts = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT p.ID, p.post_content FROM {$wpdb->posts} p
            INNER JOIN {$wpdb->term_relationships} tr ON p.ID = tr.object_id
            INNER JOIN {$wpdb->term_taxonomy} tt ON tr.term_taxonomy_id = tt.term_taxonomy_id
            WHERE tt.term_id = %d",
            $category_id
        )
    );

    foreach ($posts as $post) {
        $content = $post->post_content;
        $prompt = trim($custom_prompt) . " " . $content;
        
        $response = queryMistralAPIWithRetry($prompt, $apiKey);

        if (!empty($response) && strpos($response, 'API Error') === false) {
            $updated = $wpdb->update(
                $wpdb->posts, 
                ['gpt' => $response],
                ['ID' => $post->ID],
                ['%s'],
                ['%d']
            );

            if ($updated !== false) {
                echo "<p>Post ID {$post->ID} 'gpt' column updated successfully!</p>";
            } else {
                echo "<p>Failed to update Post ID {$post->ID}.</p>";
            }
        } else {
            echo "<p>Skipping Post ID {$post->ID} due to API error.</p>";
        }
        sleep(1); // Delay to avoid hitting API rate limits
    }
}

// Function to handle API calls with retry on rate limiting errors
function queryMistralAPIWithRetry($prompt, $apiKey, $maxRetries = 3) {
    $retryCount = 0;
    while ($retryCount < $maxRetries) {
        $response = queryMistralAPI($prompt, $apiKey);
        
        if (strpos($response, 'HTTP 429') !== false) {
            $retryCount++;
            sleep(5); // Wait before retrying to avoid hitting the rate limit
        } else {
            return $response;
        }
    }
    return "API Error: Too many requests. Please try again later.";
}



///////////////////////gpt update after post published ////////////////////
function process_post_after_publish($post_ID, $post, $update) {
    // Run only when the post is published and not in draft
    if ($post->post_status !== 'publish') {
        return;
    }

    global $wpdb;
    $table_name = $wpdb->prefix . 'posts';

    // Check if the 'gpt' column exists in the database, if not, add it
    $column_exists = $wpdb->get_results("SHOW COLUMNS FROM `$table_name` LIKE 'gpt'");
    if (empty($column_exists)) {
        $wpdb->query("ALTER TABLE `$table_name` ADD `gpt` LONGTEXT NOT NULL");
    }

    // Retrieve the 'gpt' column value for the post
    $gpt_content = $wpdb->get_var($wpdb->prepare(
        "SELECT gpt FROM `$table_name` WHERE ID = %d",
        $post_ID
    ));

    // If GPT content already exists, do not regenerate
    if (!empty($gpt_content)) {
        return;
    }

    // Get the categories of the current post
    $categories = get_the_category($post_ID);
    $category_names = wp_list_pluck($categories, 'name');

    // Choose the correct prompt based on category
    if (in_array('JURISPRUDENCES GUINEE', $category_names) || in_array('JURISPRUDENCES CCJA OHADA', $category_names)) {
        $prompt = get_option('gpt_custom_prompt_2', '') . wpautop($post->post_content);
    } else {
        $prompt = get_option('gpt_custom_prompt_1', '') . wpautop($post->post_content);
    }

    // Query the GPT API to generate content
    $api_key = get_option('gpt_api_key', ''); // Ensure API key is securely stored
    $messageResponse = queryMistralAPI($prompt, $api_key);

    // If API fails, do not update
    if ($messageResponse === "API Error" || empty($messageResponse)) {
        return;
    }

    // Store the generated GPT response in the database
    $wpdb->update(
        $table_name,
        ['gpt' => $messageResponse], // Store GPT output
        ['ID' => $post_ID], // Target specific post
        ['%s'], // Format for content
        ['%d'] // Format for post ID
    );
}

// Hook into 'wp_insert_post' to trigger function after a post is published
add_action('wp_insert_post', 'process_post_after_publish', 10, 3);




///////////////////////////disable_right_click_for_specific_user
function disable_right_click_copy_print_devtools_for_editors() {
    $current_user = wp_get_current_user();
    if (in_array('editor', $current_user->roles) && is_admin()) {
        echo '<script>
            document.addEventListener("DOMContentLoaded", function() {
                // Disable right-click globally
                document.addEventListener("contextmenu", function(event) {
                    event.preventDefault();
                });

                // Disable Ctrl + X, Ctrl + C, Ctrl + P, and F12 (Developer Tools)
                document.addEventListener("keydown", function(event) {
                    if ((event.ctrlKey && (event.key === "x" || event.key === "c" || event.key === "p")) || 
                        (event.metaKey && (event.key === "x" || event.key === "c" || event.key === "p")) || 
                        (event.key === "F12") || 
                        (event.ctrlKey && event.shiftKey && event.key === "I") || // Ctrl+Shift+I (Inspect)
                        (event.ctrlKey && event.shiftKey && event.key === "J") || // Ctrl+Shift+J (Console)
                        (event.ctrlKey && event.key === "U")) { // Ctrl+U (View Source)
                        event.preventDefault();
                    }
                });

                // Disable Print Dialog when using browser print option
                window.addEventListener("beforeprint", function(event) {
                    event.preventDefault();
                    alert("Printing is disabled.");
                });

                // Hide print styles to prevent print access
                let style = document.createElement("style");
                style.innerHTML = "@media print { body { display: none !important; } }";
                document.head.appendChild(style);

                // Disable right-click, cut, copy, print, and F12 inside TinyMCE (Visual Editor)
                let observer = new MutationObserver(() => {
                    let editorIframe = document.querySelector(".wp-editor-wrap iframe");
                    if (editorIframe) {
                        let editorDoc = editorIframe.contentDocument;
                        
                        // Disable right-click inside Visual Editor
                        editorDoc.addEventListener("contextmenu", function(event) {
                            event.preventDefault();
                        });

                        // Disable Ctrl + X, Ctrl + C, Ctrl + P, and F12 inside Visual Editor
                        editorDoc.addEventListener("keydown", function(event) {
                            if ((event.ctrlKey && (event.key === "x" || event.key === "c" || event.key === "p")) || 
                                (event.metaKey && (event.key === "x" || event.key === "c" || event.key === "p")) || 
                                (event.key === "F12") || 
                                (event.ctrlKey && event.shiftKey && event.key === "I") || 
                                (event.ctrlKey && event.shiftKey && event.key === "J") || 
                                (event.ctrlKey && event.key === "U")) {
                                event.preventDefault();
                            }
                        });

                        // Disable Print Dialog inside Visual Editor
                        editorDoc.defaultView.addEventListener("beforeprint", function(event) {
                            event.preventDefault();
                        });

                        // Apply print-blocking styles inside TinyMCE
                        let editorStyle = editorDoc.createElement("style");
                        editorStyle.innerHTML = "@media print { body { display: none !important; } }";
                        editorDoc.head.appendChild(editorStyle);
                    }
                });

                observer.observe(document.body, { childList: true, subtree: true });
            });

            // Disable DevTools when opened via right-click "Inspect" or F12
            (function() {
                let devtools = false;
                setInterval(function() {
                    let widthThreshold = window.outerWidth - window.innerWidth > 160;
                    let heightThreshold = window.outerHeight - window.innerHeight > 160;
                    if (widthThreshold || heightThreshold) {
                        devtools = true;
                        alert("Developer tools are disabled!");
                        window.location.reload();
                    }
                }, 500);
            })();
        </script>';
    }
}
add_action("admin_footer", "disable_right_click_copy_print_devtools_for_editors");


///////////////////////////search ctrl+f
function custom_search_shortcode() {
    ob_start(); // Start output buffering
    ?>
    <style>
        /* Apply Inter font globally */
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
        }

        /* Styling for highlighted matches - CSS transition removed for speed */
        mark.highlighted-match {
            background-color: #fde047; /* Yellow */
            padding: 2px 0;
            border-radius: 4px;
            /* transition: background-color 0.2s ease-in-out; */ /* Removed for speed */
        }

        /* Styling for the currently active match - CSS transition removed for speed */
        mark.current-match {
            background-color: #22c55e; /* Green */
            color: white;
            padding: 2px 0;
            border-radius: 4px;
            box-shadow: 0 0 8px rgba(34, 197, 94, 0.6); /* Subtle glow */
            outline: 2px solid #10b981; /* A clear outline for focus */
            outline-offset: 2px;
            /* transition: background-color 0.2s ease-in-out; */ /* Removed for speed */
        }

        /* Ensure the search bar is visible and styled correctly */
        #search-bar {
            position: sticky ;
            top: 1rem; /* Equivalent to Tailwind's top-4 */
            right: 1rem; /* Equivalent to Tailwind's right-4 */
            background-color: white;
            padding: 1rem; /* Equivalent to Tailwind's p-4 */
            border-radius: 0.5rem; /* Equivalent to Tailwind's rounded-lg */
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05); /* Equivalent to Tailwind's shadow-xl */
            display: flex;
            align-items: center;
            gap: 0.75rem; /* Equivalent to Tailwind's space-x-3 */
            z-index: 9; /* High z-index to ensure it's on top */
            transition: all 0.3s ease-in-out; /* Transition for search bar itself can remain */
        }

        #search-input {
            padding: 0.5rem 1rem; /* Equivalent to Tailwind's px-4 py-2 */
            border: 1px solid #d1d5db; /* Equivalent to Tailwind's border-gray-300 */
            border-radius: 0.375rem; /* Equivalent to Tailwind's rounded-md */
            width: 25rem; /* Equivalent to Tailwind's w-48 */
            transition: border-color 0.2s, box-shadow 0.2s;
        }

        #search-input:focus {
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.25);
        }

        #match-count {
            font-size: 0.875rem; /* Equivalent to Tailwind's text-sm */
            color: #4b5563; /* Equivalent to Tailwind's text-gray-600 */
            min-width: 50px;
            text-align: center;
        }

        #search-bar button {
            padding: 0.5rem; /* Equivalent to Tailwind's p-2 */
            border-radius: 0.375rem; /* Equivalent to Tailwind's rounded-md */
            color: white;
            transition: background-color 0.2s ease-in-out, transform 0.1s ease-out;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #search-bar button:active {
            transform: translateY(1px);
        }

        #prev-button, #next-button {
            background-color: #3b82f6; /* Equivalent to Tailwind's bg-blue-500 */
        }

        #prev-button:hover, #next-button:hover {
            background-color: #2563eb; /* Equivalent to Tailwind's hover:bg-blue-600 */
        }

        #close-button {
            background-color: #ef4444; /* Equivalent to Tailwind's bg-red-500 */
        }

        #close-button:hover {
            background-color: #dc2626; /* Equivalent to Tailwind's hover:bg-red-600 */
        }
    </style>

    <div id="search-bar" class="fixed top-4 right-4 bg-white p-4 rounded-lg shadow-xl flex items-center space-x-3 z-50 transition-all duration-300 ease-in-out">
        <input type="text" id="search-input" placeholder="Rechercher sur la page..." class="px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent w-48">
        <span id="match-count" class="text-sm text-gray-600 min-w-[50px] text-center">0/0</span>
        <button id="prev-button" class="p-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition-colors duration-200" title="Previous Match">
<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
  <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"/>
</svg>

        </button>
        
        
        <button id="next-button" class="p-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition-colors duration-200" title="Next Match">
<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
  <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708"/>
</svg>

        </button>
        <button id="close-button" class="p-2 bg-red-500 text-white rounded-md hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-opacity-50 transition-colors duration-200" title="Close Search">
<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
  <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
</svg>
        </button>
    </div>

    <script>
        // Ensure the DOM is fully loaded before running the script
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('search-input');
            const matchCountSpan = document.getElementById('match-count');
            const prevButton = document.getElementById('prev-button');
            const nextButton = document.getElementById('next-button');
            const closeButton = document.getElementById('close-button');
            const searchBar = document.getElementById('search-bar');

            if (!searchInput || !matchCountSpan || !prevButton || !nextButton || !closeButton || !searchBar) {
                console.warn('Custom Search Bar: Required DOM elements not found. Script might not function correctly.');
                return;
            }

            let allMatches = []; // Stores references to the <mark> elements
            let currentMatchIndex = -1;
            let debounceTimeout;

            /**
             * Debounce function to limit how often a function is called.
             */
            function debounce(func, delay) {
                return function(...args) {
                    clearTimeout(debounceTimeout);
                    debounceTimeout = setTimeout(() => func.apply(this, args), delay);
                };
            }

            /**
             * Escapes special characters in a string to be used safely in a 
             */
            function escapeRegExp(string) {
                return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // $& means the matched substring
            }

            /**
             * Clears all existing highlights from the document.
             */
            function clearHighlights() {
                // console.log('clearHighlights called.'); // Logging can be removed for slight perf gain in prod
                const existingMarks = document.querySelectorAll('mark.highlighted-match, mark.current-match');
                const parentsToNormalize = new Set();

                existingMarks.forEach(markElement => {
                    if (markElement && markElement.parentNode) {
                        parentsToNormalize.add(markElement.parentNode);
                        const textNode = document.createTextNode(markElement.textContent);
                        markElement.parentNode.replaceChild(textNode, markElement);
                    }
                });

                parentsToNormalize.forEach(parent => parent.normalize());

                allMatches = [];
                currentMatchIndex = -1;
                updateMatchCount();
            }

            /**
             * Finds all occurrences of the search text in the document's body
             * and highlights them using <mark> tags.
             * @param {string} searchText - The text to search for.
             */
            function highlightAll(searchText) {
                // console.log(`highlightAll called with searchText: "${searchText}"`);
                clearHighlights();

                if (!searchText) {
                    // console.log('Search text is empty, no highlighting.');
                    searchInput.focus();
                    return;
                }

                try {
                    const escapedSearchText = escapeRegExp(searchText);
                    const regex = new RegExp(escapedSearchText, 'gi');

                    const walker = document.createTreeWalker(
                        document.body,
                        NodeFilter.SHOW_TEXT,
                        {
                            acceptNode: function(node) {
                                const parentNodeName = node.parentNode.nodeName;
                                if (parentNodeName === 'SCRIPT' ||
                                    parentNodeName === 'STYLE' ||
                                    parentNodeName === 'MARK' || // Already highlighted by this script
                                    node.parentNode.closest('#search-bar')) {
                                    return NodeFilter.FILTER_REJECT;
                                }
                                return NodeFilter.FILTER_ACCEPT;
                            }
                        },
                        false
                    );

                    let node;
                    const nodesToProcess = [];
                    while ((node = walker.nextNode())) {
                        nodesToProcess.push(node);
                    }

                    nodesToProcess.forEach(textNode => {
                        const parent = textNode.parentNode;
                        const text = textNode.nodeValue;
                        let match;
                        let lastIndex = 0;
                        const fragment = document.createDocumentFragment();
                        let hasMatchesInNode = false;
                        regex.lastIndex = 0;

                        while ((match = regex.exec(text)) !== null) {
                            hasMatchesInNode = true;
                            if (match.index > lastIndex) {
                                fragment.appendChild(document.createTextNode(text.substring(lastIndex, match.index)));
                            }
                            const mark = document.createElement('mark');
                            mark.className = 'highlighted-match';
                            mark.textContent = match[0];
                            // mark.tabIndex = -1; // Not strictly needed if input is always focused
                            fragment.appendChild(mark);
                            allMatches.push(mark);
                            lastIndex = regex.lastIndex;
                        }

                        if (hasMatchesInNode && lastIndex < text.length) {
                            fragment.appendChild(document.createTextNode(text.substring(lastIndex)));
                        }

                        if (hasMatchesInNode) {
                            parent.replaceChild(fragment, textNode);
                        }
                    });

                    if (allMatches.length > 0) {
                        currentMatchIndex = 0;
                        const currentMatchElement = allMatches[currentMatchIndex];
                        if (currentMatchElement) {
                            currentMatchElement.classList.add('current-match');
                            currentMatchElement.scrollIntoView({ behavior: 'smooth', block: 'center' });
                            searchInput.focus();
                        }
                    } else {
                        currentMatchIndex = -1;
                        searchInput.focus();
                    }
                    updateMatchCount();
                    // console.log(`Found ${allMatches.length} matches.`);

                } catch (error) {
                    console.error("Error during highlighting:", error);
                    clearHighlights();
                    searchInput.focus();
                }
            }

            /**
             * Navigates to the next or previous match.
             * @param {number} direction - 1 for next, -1 for previous.
             */
            function navigateToMatch(direction) {
                if (allMatches.length === 0) {
                    searchInput.focus();
                    return;
                }

                // Remove the current match highlight
                if (currentMatchIndex >= 0 && currentMatchIndex < allMatches.length && allMatches[currentMatchIndex]) {
                    allMatches[currentMatchIndex].classList.remove('current-match');
                }

                // Calculate the new match index
                currentMatchIndex += direction;

                // Handle wrap-around for next and previous
                if (currentMatchIndex >= allMatches.length) {
                    currentMatchIndex = 0;
                } else if (currentMatchIndex < 0) {
                    currentMatchIndex = allMatches.length - 1;
                }

                // Highlight the new current match and scroll it into view
                const newCurrentMatchElement = allMatches[currentMatchIndex];
                if (newCurrentMatchElement) {
                    newCurrentMatchElement.classList.add('current-match');
                    newCurrentMatchElement.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center' // This ensures the match is centered in the viewport
                    });
                    searchInput.focus();
                }
                updateMatchCount();
            }

            /**
             * Updates the match count display (e.g., "1/5").
             */
            function updateMatchCount() {
                const total = allMatches.length;
                const current = total > 0 ? currentMatchIndex + 1 : 0;
                matchCountSpan.textContent = `${current}/${total}`;
                // console.log(`Match count updated to: ${current}/${total}`);
            }

            // Event Listeners
            searchInput.addEventListener('input', debounce((event) => {
                highlightAll(event.target.value);
            }, 150)); // Reduced debounce delay to 150ms

            nextButton.addEventListener('click', () => {
                navigateToMatch(1);
            });

            prevButton.addEventListener('click', () => {
                navigateToMatch(-1);
            });

            closeButton.addEventListener('click', () => {
                clearHighlights();
                searchInput.value = '';
                searchInput.focus();
            });

            document.addEventListener('keydown', (event) => {
                if (document.activeElement === searchInput && (event.key === 'g' || event.key === 'G')) {
                    if (event.ctrlKey || event.metaKey) {
                         event.preventDefault();
                         navigateToMatch(event.shiftKey ? -1 : 1);
                    }
                } else if ((event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 'g') {
                    event.preventDefault();
                    navigateToMatch(event.shiftKey ? -1 : 1);
                } else if (event.key === 'Escape') {
                    clearHighlights();
                    searchInput.value = '';
                    searchInput.focus();
                }
            });

            updateMatchCount();
            // searchInput.focus(); // Optional: Focus the search input on page load.
        }); // End DOMContentLoaded
    </script>
    <?php
    return ob_get_clean(); // Return the buffered output
}
add_shortcode('custom_search', 'custom_search_shortcode');










//////////////////////////// level config //////////////////////////////


// === STEP 1: Add User Access Level Selection to Admin Profile ===
add_action('show_user_profile', 'custom_category_access_field');
add_action('edit_user_profile', 'custom_category_access_field');

function custom_category_access_field($user) {
    // Only allow Administrator or Editor to view/edit
    if (!current_user_can('administrator') && !current_user_can('editor')) {
        return;
    }

    // Only display this field if the profile being edited belongs to a subscriber
    if (!in_array('subscriber', (array) $user->roles)) {
        return;
    }

    $level = get_user_meta($user->ID, 'custom_category_access_level', true);
    ?>
    <h3>Category Access Level</h3>
    <table class="form-table">
        <tr>
            <th><label for="custom_category_access_level">Access Level</label></th>
            <td>
                <select name="custom_category_access_level" id="custom_category_access_level">
                    <option value="">-- Select Level --</option>
                    <option value="level_1" <?php selected($level, 'level_1'); ?>>Level 1</option>
                    <option value="level_2" <?php selected($level, 'level_2'); ?>>Level 2</option>
                    <option value="level_3" <?php selected($level, 'level_3'); ?>>Level 3</option>
                    <option value="level_0" <?php selected($level, 'level_0'); ?>>Essai</option>
                </select>
                <p class="description">Assign category access level for this subscriber.</p>
            </td>
        </tr>
    </table>
    <?php
}

// === STEP 2: Save User Access Level from Profile Page ===
add_action('personal_options_update', 'save_custom_category_access_field');
add_action('edit_user_profile_update', 'save_custom_category_access_field');

function save_custom_category_access_field($user_id) {
    if (!current_user_can('edit_user', $user_id)) return false;

    if (isset($_POST['custom_category_access_level'])) {
        update_user_meta($user_id, 'custom_category_access_level', sanitize_text_field($_POST['custom_category_access_level']));
    }
}

// === STEP 3: Helper to Get All Child Categories (by Slug) ===
function get_all_child_category_ids($parent_slugs) {
    $all_ids = [];

    foreach ($parent_slugs as $slug) {
        $parent_cat = get_category_by_slug($slug);
        if ($parent_cat) {
            $ids = get_term_children($parent_cat->term_id, 'category');
            $all_ids = array_merge($all_ids, [$parent_cat->term_id], $ids);
        }
    }

    return array_unique($all_ids);
}

// === STEP 4: Restrict Access to Category Archives and Posts ===
add_action('template_redirect', 'restrict_category_and_post_access_for_subscribers');

function restrict_category_and_post_access_for_subscribers() {
    if (!is_user_logged_in()) return;

    $user = wp_get_current_user();
    if (!in_array('subscriber', (array) $user->roles)) return;

    $user_level = get_user_meta($user->ID, 'custom_category_access_level', true);

    // Define allowed categories by level
    $allowed_slugs = [];
    if ($user_level === 'level_1') {
        $allowed_slugs = ['actualites','juridiques', 'jurisprudence', 'articles-de-doctrine'];
    } elseif ($user_level === 'level_2') {
        $allowed_slugs = ['actualites','juridiques', 'jurisprudence', 'articles-de-doctrine', 'notes-juridiques'];
    } elseif ($user_level === 'level_3') {
        $allowed_slugs = ['actualites','juridiques', 'jurisprudence', 'articles-de-doctrine', 'notes-juridiques' , 'veille-juridique-et-conformite'];
    } elseif ($user_level === 'level_0') {
        $allowed_slugs = ['actualites','juridiques', 'jurisprudence', 'articles-de-doctrine', 'notes-juridiques' , 'veille-juridique-et-conformite'];
    }

    $allowed_category_ids = get_all_child_category_ids($allowed_slugs);

    // Restrict category archive
    if (is_category()) {
        $current_category = get_queried_object();
        if (!in_array($current_category->term_id, $allowed_category_ids)) {
            wp_redirect(home_url('/level'));
            exit;
        }
    }

    // Restrict post view
    if (is_single()) {
        $post_categories = wp_get_post_categories(get_the_ID());
        if (empty(array_intersect($allowed_category_ids, $post_categories))) {
            wp_redirect(home_url('/level'));
            exit;
        }
    }
}

// === STEP 5: Hide Popup Elements for Level 1 ===
add_action('wp_footer', 'hide_popup_dev_for_levels');

function hide_popup_dev_for_levels() {
    if (!is_user_logged_in()) return;

    $user = wp_get_current_user();
    if (!in_array('subscriber', (array) $user->roles)) return;

    $user_level = get_user_meta($user->ID, 'custom_category_access_level', true);

    if (in_array($user_level, ['level_1'])) {
        ?>
        <script>
        document.addEventListener("DOMContentLoaded", function() {
            var popupDev = document.getElementById("popup-dev");
            var popupButton = document.getElementById("popup-button");

            if (popupDev) popupDev.style.display = "none";
            if (popupButton) popupButton.style.display = "none";
        });
        </script>
        <?php
    }
}

// === STEP 6: Show Download Button with Limit for Level 2 and 3 Users ===
add_filter('the_content', 'register_post_buttons');

function register_post_buttons($content) {
    if (!is_singular('post') || !is_user_logged_in()) return $content;

    $user = wp_get_current_user();
    if (!in_array('subscriber', (array) $user->roles)) return $content;

    $user_level = get_user_meta($user->ID, 'custom_category_access_level', true);
    $user_id = $user->ID;
    $count = (int) get_user_meta($user_id, 'download_count', true);
    $count = is_numeric($count) ? $count : 0;

    $limit = 0;
    if ($user_level === 'level_2') {
        $limit = 10;
    } elseif ($user_level === 'level_3') {
        $limit = 20;
    }

    // Only show download button if a limit is defined
    if ($limit > 0) {
        if ($count < $limit) {
            $buttons = do_shortcode('[post_buttons]');
$content = '<p class="count">Téléchargements utilisés : ' . $count . '/' . $limit . '</p>' . $buttons . $content;

        } else {
            $content = '<p class="count">' . "<strong>Vous avez atteint votre limite de téléchargement " . $limit . '/' . $limit . '</strong></p>' . $content; 
        }
    }

    return $content;
}


//////////// show ocr mistral for level 3 ///

function guilaw_add_ocr_mistral_menu_pages() {
    $user = wp_get_current_user();

    // Ensure the user is logged in and has the 'subscriber' role
    if ( in_array( 'subscriber', (array) $user->roles, true ) ) {
        // Get the custom user level
        $user_level = get_user_meta( $user->ID, 'custom_category_access_level', true );

        // Show menu only for level_3 OR level_0 users
        if ( in_array( $user_level, array( 'level_3', 'level_0' ), true ) ) {
            add_menu_page(
                'Ocr Mistral',                            // Page title
                'Ocr-mistral',                            // Menu title
                'read',                                   // Capability
                'https://kytisa.com/ocr-pdf-to-docx/',    // External link
                null,                                     // No callback (since it's a link)
                'dashicons-media-code',                   // Icon
                6                                         // Position
            );
        }
    }
}
add_action('admin_menu', 'guilaw_add_ocr_mistral_menu_pages');




/////////////////////////////////////////////////////////////////

/**
 * Custom User Profile Dashboard with Avatar Upload and Login Form
 */
function custom_user_profile_dashboard() {
    // If user is not logged in, show login form
    if (!is_user_logged_in()) {
        return custom_login_form();
    }

    $user = wp_get_current_user();
    ob_start();

    // Handle form submissions
    $message = '';
    $active_tab = isset($_POST['action']) && $_POST['action'] === 'change_password' ? 'change-password' : 'profile-info';

    // Update profile info
    if (isset($_POST['action']) && $_POST['action'] === 'update_profile' && wp_verify_nonce($_POST['profile_nonce'], 'update_profile_nonce')) {
        $userdata = array(
            'ID' => $user->ID,
            'first_name' => sanitize_text_field($_POST['first_name']),
            'last_name' => sanitize_text_field($_POST['last_name']),
            'user_email' => sanitize_email($_POST['email']),
            'description' => sanitize_textarea_field($_POST['description'])
        );

        if (wp_update_user($userdata)) {
            $message = '<div class="profile-notice success"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg> ' . __('Profil mis à jour avec succès!', 'textdomain') . '</div>';
        } else {
            $message = '<div class="profile-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . __('Erreur lors de la mise à jour du profil.', 'textdomain') . '</div>';
        }
    }

    // Change password
    if (isset($_POST['action']) && $_POST['action'] === 'change_password' && wp_verify_nonce($_POST['password_nonce'], 'change_password_nonce')) {
        if ($_POST['new_password'] !== $_POST['confirm_password']) {
            $message = '<div class="profile-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . __('Les mots de passe ne correspondent pas.', 'textdomain') . '</div>';
        } else {
            wp_set_password(sanitize_text_field($_POST['new_password']), $user->ID);
            $message = '<div class="profile-notice success"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg> ' . __('Mot de passe changé avec succès!', 'textdomain') . '</div>';
            $active_tab = 'profile-info';
        }
    }

    // Handle avatar upload
    if (isset($_POST['action']) && $_POST['action'] === 'update_avatar' && wp_verify_nonce($_POST['avatar_nonce'], 'update_avatar_nonce')) {
        if (!empty($_FILES['avatar']['name'])) {
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            require_once(ABSPATH . 'wp-admin/includes/file.php');
            require_once(ABSPATH . 'wp-admin/includes/media.php');

            $attachment_id = media_handle_upload('avatar', 0);

            if (is_wp_error($attachment_id)) {
                $message = '<div class="profile-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . $attachment_id->get_error_message() . '</div>';
            } else {
                update_user_meta($user->ID, 'custom_user_avatar', $attachment_id);
                add_filter('get_avatar', 'custom_get_avatar', 10, 5);
                $message = '<div class="profile-notice success"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg> ' . __('Avatar mis à jour avec succès!', 'textdomain') . '</div>';
            }
        } else {
            $message = '<div class="profile-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . __('Veuillez sélectionner une image à télécharger.', 'textdomain') . '</div>';
        }
    }

    $avatar_id = get_user_meta($user->ID, 'custom_user_avatar', true);
    $avatar_url = $avatar_id ? wp_get_attachment_image_url($avatar_id, 'thumbnail') : '';
    ?>

    <div class="profile-dashboard-container">
        <?php echo $message;
        
        $user = wp_get_current_user();
$user_roles = (array) $user->roles;
$user_level = get_user_meta($user->ID, 'custom_category_access_level', true);
        
        ?>

        <div class="profile-header">
            <div class="header-content">
                <h1><?php _e('Mon Profil', 'textdomain'); ?></h1>
        <p><?php  _e(
        'Gérez les paramètres de votre compte et vos informations de profil : (' . "<b>" . strtoupper($user_level) . "</b>)", 
        'textdomain'  ); ?> </p>
            </div>
            <div class="logout-button">
                <a href="<?php echo wp_logout_url(); ?>" class="btn-logout">
                    <?php _e('Déconnexion', 'textdomain'); ?>
                </a>
            </div>
        </div>

        <div class="profile-grid">
            <div class="profile-sidebar">
                <div class="profile-card">
                    <div class="avatar-upload">
                        <div class="avatar-preview">
                            <?php if ($avatar_url) : ?>
                                <img src="<?php echo esc_url($avatar_url); ?>" alt="Photo de profil">
                            <?php else : ?>
                                <?php echo get_avatar($user->ID, 120); ?>
                            <?php endif; ?>
                        </div>
                        <form id="avatar-form" method="post" enctype="multipart/form-data" class="avatar-form">
                            <input type="hidden" name="action" value="update_avatar">
                            <?php wp_nonce_field('update_avatar_nonce', 'avatar_nonce'); ?>
                            <label for="avatar-upload" class="avatar-upload-label">
                                <span class="upload-icon">+</span>
                                <span class="upload-text"><?php _e('Changer la photo', 'textdomain'); ?></span>
                                <input type="file" id="avatar-upload" name="avatar" accept="image/*" style="display: none;">
                            </label>
                        </form>
                    </div>
                    <div class="user-info">
                        <h3><?php echo esc_html($user->display_name); ?></h3>
                        <p><?php echo esc_html($user->user_email); ?></p>
                    </div>
                </div>

                <nav class="profile-nav">
                    <ul>
                        <li class="<?php echo $active_tab === 'profile-info' ? 'active' : ''; ?>">
                            <a href="#profile-info" data-tab="profile-info">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                <?php _e('Informations du profil', 'textdomain'); ?>
                            </a>
                        </li>
                        <li class="<?php echo $active_tab === 'change-password' ? 'active' : ''; ?>">
                            <a href="#change-password" data-tab="change-password">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
                                <?php _e('Changer le mot de passe', 'textdomain'); ?>
                            </a>
                        </li>
                        
        
              
<?php
// Get current user and their roles
$current_user = wp_get_current_user();
$user_roles   = (array) $current_user->roles;

// Get your custom “category access level” meta
$user_level = get_user_meta( $current_user->ID, 'custom_category_access_level', true );

// Only show OCR if subscriber AND level is level_0 or level_3
if (
    in_array( 'subscriber', $user_roles, true ) &&
    in_array( $user_level, [ 'level_0', 'level_3' ], true )
) : ?>
    <li class="<?php echo esc_attr( $active_tab === 'ocr' ? 'active' : '' ); ?>">
        <a href="#ocr" data-tab="ocr">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" 
                 viewBox="0 0 24 24" fill="none" stroke="currentColor" 
                 stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                <polyline points="14 2 14 8 20 8"/>
                <line x1="16" y1="13" x2="8" y2="13"/>
                <line x1="16" y1="17" x2="8" y2="17"/>
                <line x1="10" y1="9" x2="8" y2="9"/>
            </svg>
            <?php esc_html_e( 'OCR', 'textdomain' ); ?>
        </a>
    </li>
<?php endif; ?>

          
          
                        
                        
                    
                        
                    </ul>
                </nav>
            </div>

            <div class="profile-content">
                <div id="profile-info" class="profile-tab-content <?php echo $active_tab === 'profile-info' ? 'active' : ''; ?>">
                    <div class="profile-section">
                        <h2><?php _e('Informations du profil', 'textdomain'); ?></h2>
                        <p class="section-description"><?php _e('Mettez à jour vos informations personnelles et votre biographie', 'textdomain'); ?></p>

                        <form method="post" class="profile-form">
                            <input type="hidden" name="action" value="update_profile">

                            <div class="form-row">
                                <div class="form-group">
                                    <label for="first_name"><?php _e('Prénom', 'textdomain'); ?></label>
                                    <input type="text" name="first_name" id="first_name" value="<?php echo esc_attr($user->first_name); ?>">
                                </div>

                                <div class="form-group">
                                    <label for="last_name"><?php _e('Nom de famille', 'textdomain'); ?></label>
                                    <input type="text" name="last_name" id="last_name" value="<?php echo esc_attr($user->last_name); ?>">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="email"><?php _e('Adresse e-mail', 'textdomain'); ?></label>
                                <input type="email" name="email" id="email" value="<?php echo esc_attr($user->user_email); ?>">
                            </div>

                            <div class="form-group">
                                <label for="description"><?php _e('À propos de moi', 'textdomain'); ?></label>
                                <textarea name="description" id="description" rows="4"><?php echo esc_textarea($user->description); ?></textarea>
                            </div>

                            <?php wp_nonce_field('update_profile_nonce', 'profile_nonce'); ?>
                            <button type="submit" class="btn-primary">
                                <?php _e('Sauvegarder les modifications', 'textdomain'); ?>
                            </button>
                        </form>
                    </div>
                </div>

                <div id="change-password" class="profile-tab-content <?php echo $active_tab === 'change-password' ? 'active' : ''; ?>">
                    <div class="profile-section">
                        <h2><?php _e('Changer le mot de passe', 'textdomain'); ?></h2>
                        <p class="section-description"><?php _e('Sécurisez votre compte avec un nouveau mot de passe', 'textdomain'); ?></p>

                        <form method="post" class="profile-form">
                            <input type="hidden" name="action" value="change_password">

                            <div class="form-group">
                                <label for="current_password"><?php _e('Mot de passe actuel', 'textdomain'); ?></label>
                                <input type="password" name="current_password" id="current_password" autocomplete="current-password">
                            </div>

                            <div class="form-group">
                                <label for="new_password"><?php _e('Nouveau mot de passe', 'textdomain'); ?></label>
                                <input type="password" name="new_password" id="new_password" autocomplete="new-password">
                                <div class="password-hint"><?php _e('Minimum 8 caractères avec au moins un chiffre', 'textdomain'); ?></div>
                            </div>

                            <div class="form-group">
                                <label for="confirm_password"><?php _e('Confirmer le nouveau mot de passe', 'textdomain'); ?></label>
                                <input type="password" name="confirm_password" id="confirm_password" autocomplete="new-password">
                            </div>

                            <?php wp_nonce_field('change_password_nonce', 'password_nonce'); ?>
                            <button type="submit" class="btn-primary">
                                <?php _e('Mettre à jour le mot de passe', 'textdomain'); ?>
                            </button>
                        </form>
                    </div>
                </div>
                
                
           
                
                                <div id="ocr" class="profile-tab-content <?php echo $active_tab === 'ocr' ? 'active' : ''; ?>">
                    <div class="profile-section">
                       
                     
                 <a href="<?php echo site_url('/ocr-pdf-to-docx/'); ?>">

                         <button class="btn-primary"> 
                                   <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" 
     viewBox="0 0 24 24" fill="none" stroke="currentColor" 
     stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
  <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
  <polyline points="14 2 14 8 20 8"/>
  <line x1="16" y1="13" x2="8" y2="13"/>
  <line x1="16" y1="17" x2="8" y2="17"/>
  <line x1="10" y1="9" x2="8" y2="9"/>
</svg> Ocr: PDF -> Word

</button>
</a>

                       
                       
                       
                        
                        
                    </div>
                </div>
              
                
                
            </div>
        </div>
    </div>

    <?php echo custom_profile_styles(); ?>
    <?php echo custom_profile_scripts(); ?>

    <?php
    return ob_get_clean();
}

/**
 * Custom Login Form
 */
function custom_login_form() {
    ob_start();
    
    $message = '';
    $redirect_to = isset($_GET['redirect_to']) ? $_GET['redirect_to'] : '';
    
    // Handle login form submission
    if (isset($_POST['action']) && $_POST['action'] === 'custom_login' && wp_verify_nonce($_POST['login_nonce'], 'custom_login_nonce')) {
        $username = sanitize_user($_POST['username']);
        $password = $_POST['password'];
        $remember = isset($_POST['remember']) ? true : false;
        
        $creds = array(
            'user_login'    => $username,
            'user_password' => $password,
            'remember'      => $remember
        );
        
        $user = wp_signon($creds, false);
        
        if (is_wp_error($user)) {
            $message = '<div class="login-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . __('Nom d\'utilisateur ou mot de passe incorrect.', 'textdomain') . '</div>';
        } else {
            // Successful login - redirect to prevent form resubmission
            $redirect_url = !empty($redirect_to) ? $redirect_to : $_SERVER['REQUEST_URI'];
            wp_redirect($redirect_url);
            exit;
        }
    }
    
    // Handle lost password
    if (isset($_POST['action']) && $_POST['action'] === 'lost_password' && wp_verify_nonce($_POST['lost_password_nonce'], 'lost_password_nonce')) {
        $user_login = sanitize_text_field($_POST['user_login']);
        
        if (empty($user_login)) {
            $message = '<div class="login-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . __('Veuillez entrer votre nom d\'utilisateur ou adresse e-mail.', 'textdomain') . '</div>';
        } else {
            $result = retrieve_password($user_login);
            if (is_wp_error($result)) {
                $message = '<div class="login-notice error"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg> ' . $result->get_error_message() . '</div>';
            } else {
                $message = '<div class="login-notice success"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg> ' . __('Instructions de réinitialisation du mot de passe envoyées par e-mail.', 'textdomain') . '</div>';
            }
        }
    }
    ?>
    
    <div class="login-container">
        <?php echo $message; ?>
        
        <div class="login-card">
            <div class="login-header">
                <h1><?php _e('Connexion', 'textdomain'); ?></h1>
                <p><?php _e('Connectez-vous pour accéder à votre profil', 'textdomain'); ?></p>
            </div>
            

            
            <div id="login-form" class="login-tab-content active">
                <form method="post" class="login-form">
                    <input type="hidden" name="action" value="custom_login">
                    <?php wp_nonce_field('custom_login_nonce', 'login_nonce'); ?>
                    
                    <div class="form-group">
                        <label for="username"><?php _e('Nom d\'utilisateur ou E-mail', 'textdomain'); ?></label>
                        <input type="text" name="username" id="username" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password"><?php _e('Mot de passe', 'textdomain'); ?></label>
                        <input type="password" name="password" id="password" required>
                    </div>
                    
                    <div class="form-group checkbox-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="remember" value="1">
                            <span class="checkmark"></span>
                            <?php _e('Se souvenir de moi', 'textdomain'); ?>
                        </label>
                    </div>
                    
                    <button type="submit" class="btn-primary btn-full">
                        <?php _e('Se connecter', 'textdomain'); ?>
                    </button>
                </form>
            </div>
            
            <div id="forgot-password" class="login-tab-content">
                <form method="post" class="login-form">
                    <input type="hidden" name="action" value="lost_password">
                    <?php wp_nonce_field('lost_password_nonce', 'lost_password_nonce'); ?>
                    
                    <div class="form-group">
                        <label for="user_login"><?php _e('Nom d\'utilisateur ou E-mail', 'textdomain'); ?></label>
                        <input type="text" name="user_login" id="user_login" required>
                    </div>
                    
                    <button type="submit" class="btn-primary btn-full">
                        <?php _e('Réinitialiser le mot de passe', 'textdomain'); ?>
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <?php echo custom_profile_styles(); ?>
    <?php echo custom_login_scripts(); ?>
    
    <?php
    return ob_get_clean();
}

/**
 * Profile Styles
 */
function custom_profile_styles() {
    ob_start();
    ?>
    <style>
    :root {
        --primary-color: #4361ee;
        --primary-hover: #3a56d4;
        --text-color: #2b2b2b;
        --light-text: #6c757d;
        --border-color: #e9ecef;
        --bg-color: #f8f9fa;
        --card-bg: #ffffff;
        --success-color: #28a745;
        --error-color: #dc3545;
        --border-radius: 8px;
        --box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        --transition: all 0.3s ease;
    }

    body {
        background-color: var(--bg-color);
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    /* Login Styles */
    .login-container {
        max-width: 450px;
        margin: 4rem auto;
        padding: 2rem;
        color: var(--text-color);
    }

    .login-card {
        width: max-content;
        background: var(--card-bg);
        border-radius: var(--border-radius);
        padding: 2rem;
        box-shadow: var(--box-shadow);
    }

    .login-header {
        text-align: center;
        margin-bottom: 2rem;
    }

    .login-header h1 {
        font-size: 2rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: var(--text-color);
    }

    .login-header p {
        color: var(--light-text);
        margin: 0;
    }

    .login-tabs {
        display: flex;
        margin-bottom: 1.5rem;
        border-bottom: 1px solid var(--border-color);
    }

    .tab-button {
        flex: 1;
        padding: 0.75rem 1rem;
        border: none;
        background: none;
        color: var(--light-text);
        cursor: pointer;
        border-bottom: 2px solid transparent;
        transition: var(--transition);
        font-size: 0.9rem;
        font-weight: 500;
    }

    .tab-button.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }

    .tab-button:hover {
        color: var(--primary-color);
    }

    .login-tab-content {
        display: none;
    }

    .login-tab-content.active {
        display: block;
        animation: fadeIn 0.3s ease;
    }

    .login-form {
        max-width: 100%;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        margin-bottom: 1.5rem;
    }

    .checkbox-label {
        display: flex;
        align-items: center;
        cursor: pointer;
        font-size: 0.9rem;
        color: var(--light-text);
    }

    .checkbox-label input[type="checkbox"] {
        display: none;
    }

    .checkmark {
        width: 18px;
        height: 18px;
        border: 2px solid var(--border-color);
        border-radius: 3px;
        margin-right: 0.5rem;
        position: relative;
        transition: var(--transition);
    }

    .checkbox-label input[type="checkbox"]:checked + .checkmark {
        background: var(--primary-color);
        border-color: var(--primary-color);
    }

    .checkbox-label input[type="checkbox"]:checked + .checkmark::after {
        content: '✓';
        position: absolute;
        top: -2px;
        left: 2px;
        color: white;
        font-size: 12px;
        font-weight: bold;
    }

    .btn-full {
        width: 100%;
    }

    .login-notice {
        padding: 1rem;
        border-radius: var(--border-radius);
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .login-notice.success {
        background: rgba(40, 167, 69, 0.1);
        color: var(--success-color);
        border-left: 4px solid var(--success-color);
    }

    .login-notice.error {
        background: rgba(220, 53, 69, 0.1);
        color: var(--error-color);
        border-left: 4px solid var(--error-color);
    }

    /* Profile Dashboard Styles */
    .profile-dashboard-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 2rem;
        color: var(--text-color);
    }

    .profile-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }

    .header-content h1 {
        font-size: 2rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: var(--text-color);
    }

    .header-content p {
        color: var(--light-text);
        margin: 0;
    }

    .btn-logout {
        background: var(--error-color);
        color: white;
        border: none;
        padding: 0.5rem 1rem;
        border-radius: var(--border-radius);
        font-size: 1rem;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        transition: var(--transition);
    }

    .btn-logout:hover {
        background: #c82333;
    }

    .profile-grid {
        display: grid;
        grid-template-columns: 280px 1fr;
        gap: 2rem;
    }

    .profile-sidebar {
        display: flex;
        flex-direction: column;
        gap: 1.5rem;
    }

    .profile-card {
        background: var(--card-bg);
        border-radius: var(--border-radius);
        padding: 1.5rem;
        box-shadow: var(--box-shadow);
        text-align: center;
        transition: var(--transition);
    }

    .avatar-upload {
        position: relative;
        margin: 0 auto 1rem;
        width: 120px;
        height: 120px;
    }

    .avatar-preview {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        overflow: hidden;
        border: 3px solid var(--border-color);
        transition: var(--transition);
    }

    .avatar-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .avatar-upload-label {
        position: absolute;
        bottom: 0;
        right: 0;
        background: var(--primary-color);
        color: white;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: var(--transition);
    }

    .avatar-upload-label:hover {
        background: var(--primary-hover);
        transform: scale(1.1);
    }

    .upload-icon {
        font-size: 1.2rem;
        line-height: 1;
    }

    .upload-text {
        display: none;
    }

    .user-info h3 {
        font-size: 1.2rem;
        margin: 0.5rem 0 0;
    }

    .user-info p {
        color: var(--light-text);
        font-size: 0.9rem;
        margin: 0;
    }

    .profile-nav ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .profile-nav li {
        margin-bottom: 0.5rem;
    }

    .profile-nav a {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 0.75rem 1rem;
        color: var(--light-text);
        text-decoration: none;
        border-radius: var(--border-radius);
        transition: var(--transition);
    }

    .profile-nav a svg {
        opacity: 0.7;
    }

    .profile-nav a:hover,
    .profile-nav li.active a {
        background: rgba(67, 97, 238, 0.1);
        color: var(--primary-color);
    }

    .profile-nav li.active a svg {
        opacity: 1;
    }

    .profile-content {
        background: var(--card-bg);
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        padding: 2rem;
    }

    .profile-tab-content {
        display: none;
    }

    .profile-tab-content.active {
        display: block;
        animation: fadeIn 0.5s ease;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .profile-section h2 {
        font-size: 1.5rem;
        margin-top: 0;
        margin-bottom: 0.5rem;
    }

    .section-description {
        color: var(--light-text);
        margin-top: 0;
        margin-bottom: 1.5rem;
    }

    .profile-form {
        max-width: 600px;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
        margin-bottom: 1.5rem;
    }

    .form-group {
        margin-bottom: 1.5rem;
    }

    .form-group label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
    }

    .form-group input,
    .form-group textarea,
    .form-group select {
        width: 100%;
        padding: 0.75rem;
        border: 1px solid var(--border-color);
        border-radius: var(--border-radius);
        font-size: 1rem;
        transition: var(--transition);
    }

    .form-group input:focus,
    .form-group textarea:focus {
        border-color: var(--primary-color);
        outline: none;
        box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
    }

    .form-group textarea {
        min-height: 120px;
        resize: vertical;
    }

    .password-hint {
        font-size: 0.8rem;
        color: var(--light-text);
        margin-top: 0.25rem;
    }

    .btn-primary {
        background: var(--primary-color);
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: var(--border-radius);
        font-size: 1rem;
        font-weight: 500;
        cursor: pointer;
        transition: var(--transition);
    }

    .btn-primary:hover {
        background: var(--primary-hover);
        transform: translateY(-2px);
    }

    .profile-notice {
        padding: 1rem;
        border-radius: var(--border-radius);
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .profile-notice.success {
        background: rgba(40, 167, 69, 0.1);
        color: var(--success-color);
        border-left: 4px solid var(--success-color);
    }

    .profile-notice.error {
        background: rgba(220, 53, 69, 0.1);
        color: var(--error-color);
        border-left: 4px solid var(--error-color);
    }

    @media (max-width: 768px) {
        .profile-grid {
            grid-template-columns: 1fr;
        }

        .form-row {
            grid-template-columns: 1fr;
            gap: 1rem;
        }

        .login-container {
            margin: 2rem auto;
            padding: 1rem;
        }

        .login-card {
            padding: 1.5rem;
        }
    }
    </style>
    <?php
    return ob_get_clean();
}

/**
 * Profile Scripts
 */
function custom_profile_scripts() {
    ob_start();
    ?>
    <script>
    jQuery(document).ready(function($) {
        $('.profile-nav a').on('click', function(e) {
            e.preventDefault();
            var tab = $(this).data('tab');
            $('.profile-nav li').removeClass('active');
            $(this).parent().addClass('active');
            $('.profile-tab-content').removeClass('active');
            $('#' + tab).addClass('active');
        });

        $('#avatar-upload').on('change', function() {
            if (this.files && this.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('.avatar-preview').html('<img src="' + e.target.result + '" alt="Aperçu de l\'avatar">');
                }

                reader.readAsDataURL(this.files[0]);
                $('#avatar-form').submit();
            }
        });
    });
    </script>
    <?php
    return ob_get_clean();
}

/**
 * Login Scripts
 */
function custom_login_scripts() {
    ob_start();
    ?>
    <script>
    jQuery(document).ready(function($) {
        $('.tab-button').on('click', function() {
            var tab = $(this).data('tab');
            $('.tab-button').removeClass('active');
            $(this).addClass('active');
            $('.login-tab-content').removeClass('active');
            $('#' + tab).addClass('active');
        });
    });
    </script>
    <?php
    return ob_get_clean();
}

/**
 * Custom Avatar Function
 */
function custom_get_avatar($avatar, $id_or_email, $size, $default, $alt) {
    $user = false;

    if (is_numeric($id_or_email)) {
        $id = (int) $id_or_email;
        $user = get_user_by('id', $id);
    } elseif (is_object($id_or_email)) {
        if (!empty($id_or_email->user_id)) {
            $id = (int) $id_or_email->user_id;
            $user = get_user_by('id', $id);
        }
    } else {
        $user = get_user_by('email', $id_or_email);
    }

    if ($user && is_object($user)) {
        $avatar_id = get_user_meta($user->ID, 'custom_user_avatar', true);

        if ($avatar_id) {
            $avatar_url = wp_get_attachment_image_url($avatar_id, [ $size, $size ]);
            if ($avatar_url) {
                return sprintf(
                    "<img src='%s' width='%d' height='%d' alt='%s' class='avatar avatar-%d' />",
                    esc_url($avatar_url),
                    $size,
                    $size,
                    esc_attr($alt),
                    $size
                );
            }
        }
    }

    return $avatar;
}
add_filter('get_avatar', 'custom_get_avatar', 10, 5);

// Register the shortcode
add_shortcode('custom_user_profile', 'custom_user_profile_dashboard');

// Admin redirects and admin bar removal
// Hide admin bar for subscribers
add_action('after_setup_theme', function () {
    if (is_user_logged_in()) {
        $user = wp_get_current_user();
        if (in_array('subscriber', (array) $user->roles)) {
            show_admin_bar(false);
        }
    }
});

// Redirect subscribers away from wp-admin and profile.php
add_action('admin_init', function () {
    if (!is_user_logged_in()) return;

    $user = wp_get_current_user();

    if (in_array('subscriber', (array) $user->roles)) {
        // Allow admin-ajax.php and admin-post.php (used by plugins)
        $current_url = $_SERVER['REQUEST_URI'];
        if (
            strpos($current_url, 'admin-ajax.php') === false &&
            strpos($current_url, 'admin-post.php') === false
        ) {
            wp_redirect(site_url('/account'));
            exit;
        }
    }
});




// Redirect users to homepage after logout
add_action('wp_logout', function() {
    wp_safe_redirect(home_url());
    exit;
});


add_action('template_redirect', 'redirect_logged_in_user_from_login');

function redirect_logged_in_user_from_login() {
    if (is_user_logged_in() && is_page('login')) {
        wp_redirect(home_url('/account'));
        exit;
    }
}






// redirect ocr page to 404 error if not admin-editor-level-3
function check_user_access_and_redirect() {
    // Only run on our restricted page
    if ( strpos( $_SERVER['REQUEST_URI'], '/ocr-pdf-to-docx/' ) !== false ) {
        $user       = wp_get_current_user();
        $user_roles = (array) $user->roles;
        $user_level = get_user_meta( $user->ID, 'custom_category_access_level', true );

        // Allow admins, editors, or subscribers at level_3 or level_0
        $has_access = 
            in_array( 'administrator', $user_roles, true )
            || in_array( 'editor', $user_roles, true )
            || ( in_array( 'subscriber', $user_roles, true )
                 && in_array( $user_level, array( 'level_3', 'level_0' ), true ) );

        if ( ! $has_access ) {
            wp_redirect( home_url( '/not-found' ) ); // adjust slug as needed
            exit;
        }
    }
}
add_action('template_redirect', 'check_user_access_and_redirect');


  /////////////////////////////blur content////////////////////////////////////
  
  
function restrict_content_with_elementor_template($content) {
    // Only run on single posts that are NOT in the 'Actualités' category
    if (is_single() && ! has_category('Actualités')) {
        $user = wp_get_current_user();
        $restricted_roles = ['subscriber', 'editor'];

        $is_guest = !is_user_logged_in();
        // Note: This variable is defined but not used to restrict content for these roles.
        $is_restricted_role = array_intersect($restricted_roles, $user->roles);

        if ($is_guest) {
            // Limit content to the first 5 lines (plain text)
            $lines = preg_split('/\r\n|\r|\n/', strip_tags($content));
            $first_five = array_slice($lines, 0, 5);
            $preview_text = implode('<br>', $first_five);

            // Gradient overlay container
            $output = '
            <div style="position: relative; max-height: 12em; overflow: hidden; line-height: 1.6em;">
                <div>' . $preview_text . '</div>
                <div style="
                    position: absolute;
                    bottom: 0;
                    left: 0;
                    width: 100%;
                    height: 4em;
                    background: linear-gradient(to bottom, rgba(255,255,255,0) 0%, #ffffff 100%);
                "></div>
            </div>';

            // Elementor membership call-to-action
            $output .= do_shortcode('[elementor-template id="72503"]');

            return $output;
        }
    }

    // Return original content for 'Actualités' posts or for logged-in users
    return $content;
}
add_filter('the_content', 'restrict_content_with_elementor_template');

  ///////////////////secure login ////////////////




function my_custom_login_captcha_field() {
    if ( ! session_id() ) session_start();
    $num1 = rand(1, 9);
    $num2 = rand(1, 9);
    $_SESSION['captcha_answer'] = $num1 + $num2;
    return '
    <p class="login-captcha">
        <label for="captcha_challenge">Security Question</label>
        ' . $num1 . ' + ' . $num2 . ' = ?
        <input type="text" name="captcha_challenge" id="captcha_challenge" class="input" size="2" required="required" />
    </p>';
}

function my_custom_login_captcha_validation($user, $username, $password) {
    if ( ! session_id() ) session_start();
    if ( isset($_POST['log']) ) {
        if ( !isset($_SESSION['captcha_answer']) || !isset($_POST['captcha_challenge']) || (int)$_POST['captcha_challenge'] !== $_SESSION['captcha_answer'] ) {
            unset($_SESSION['captcha_answer']);
            return new WP_Error('captcha_error', '<strong>ERROR</strong>: Incorrect answer to the security question.');
        }
    }
    unset($_SESSION['captcha_answer']);
    return $user;
}
add_filter('authenticate', 'my_custom_login_captcha_validation', 20, 3);
add_action('login_form', function() { echo my_custom_login_captcha_field(); });


// =====================================================================
// PART 2: The Shortcode Function (Updated with reliable inline styles)
// =====================================================================

function my_custom_login_shortcode_function() {
    // This static variable ensures the styles are only added once, even if you use the shortcode multiple times on a page.
    static $styles_added = false;

    // We will build the final HTML output in this variable.
    $output = '';
    
    // If the styles have not been added yet, add them now.
    if ( ! $styles_added ) {
        $output .= '
        <style>
            /* --- Custom Login Form Design --- */
            .my-custom-login-container {
                max-width: 420px; margin: 40px auto; padding: 30px; background-color: #f9f9f9;
                border: 1px solid #ddd; border-radius: 8px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
            }
            .my-custom-login-container h3 {
                text-align: center; font-size: 24px; margin-top: 0; margin-bottom: 25px; color: #333;
            }
            .my-custom-login-container form p { margin-bottom: 15px; }
            .my-custom-login-container label { display: block; font-weight: 600; color: #555; margin-bottom: 5px; }
            .my-custom-login-container input[type="text"],
            .my-custom-login-container input[type="password"] {
                width: 100%; padding: 12px; border: 1px solid #ccc; border-radius: 4px;
                box-sizing: border-box; transition: border-color 0.3s;
            }
            .my-custom-login-container input[type="text"]:focus,
            .my-custom-login-container input[type="password"]:focus {
                border-color: #0073aa; outline: none;
            }
            .my-custom-login-container .login-submit input[type="submit"] {
                width: 100%; padding: 12px; background-color: #0073aa; color: #fff;
                border: none; border-radius: 4px; font-size: 16px; font-weight: 600;
                cursor: pointer; transition: background-color 0.3s;
            }
            .my-custom-login-container .login-submit input[type="submit"]:hover { background-color: #005a87; }
            .my-custom-login-container .login-error-message {
                background-color: #fbeaea; border: 1px solid #dc3232; color: #dc3232;
                padding: 15px; border-radius: 4px; margin-bottom: 20px; text-align: center;
            }
            /* --- Mobile Responsive Design --- */
            @media (max-width: 600px) {
                .my-custom-login-container { width: 90%; padding: 20px; margin-top: 20px; }
                .my-custom-login-container h3 { font-size: 20px; }
            }
        </style>';
        $styles_added = true; // Mark styles as added.
    }

    if ( is_user_logged_in() ) {
        $current_user = wp_get_current_user();
        $output .= '
        <div class="my-custom-login-container">
            <h3>Welcome Back!</h3>
            <p style="text-align:center;">You are already logged in as ' . esc_html($current_user->display_name) . '.</p>
            <a style="display:block; text-align:center;" href="' . wp_logout_url(get_permalink()) . '">Logout</a>
        </div>';
        return $output;
    }

    $login_form_action = esc_url( site_url( 'wp-login.php', 'login_post' ) );
    $redirect_after_login = esc_url( home_url('/') );

    $output .= '<div class="my-custom-login-container">';
    $output .= '<h3>Member Login</h3>';

    if ( isset($_GET['login']) && $_GET['login'] == 'failed' ) {
        $output .= '<div class="login-error-message">Login failed. Please check your credentials.</div>';
    }

    $output .= '
    <form name="customloginform" id="customloginform" action="' . $login_form_action . '" method="post">
        <p class="login-username">
            <label for="user_login">Username or Email</label>
            <input type="text" name="log" id="user_login" value="" />
        </p>
        <p class="login-password">
            <label for="user_pass">Password</label>
            <input type="password" name="pwd" id="user_pass" value="" />
        </p>';

    $output .= my_custom_login_captcha_field();

    $output .= '
        <p class="login-remember">
            <label><input name="rememberme" type="checkbox" id="rememberme" value="forever"> Remember Me</label>
        </p>
        <p class="login-submit">
            <input type="submit" name="wp-submit" id="wp-submit" value="Log In" />
            <input type="hidden" name="redirect_to" value="' . $redirect_after_login . '" />
        </p>
    </form>';
    
    $output .= '</div>';

    return $output;
}
add_shortcode('my_custom_login_form', 'my_custom_login_shortcode_function');


// Redirect on failed login (Unchanged but still required)
function my_custom_login_fail_redirect() {
    $referer_url = wp_get_referer();
    if ( !empty($referer_url) && !strstr($referer_url, 'wp-login') && !strstr($referer_url, 'wp-admin') ) {
        wp_redirect( $referer_url . '?login=failed' );
        exit;
    }
}
add_action('wp_login_failed', 'my_custom_login_fail_redirect');




//////////////////////////////////////////////////////////



/**
 * 1. SCHEDULES the RAG script to run after a delay when a post is published.
 *
 * This function hooks into the post publishing action but does NOT run the
 * heavy command itself. Instead, it tells WordPress to run our custom action
 * ('guilaw_run_delayed_rag_action') in 10 seconds, passing the post ID to it.
 *
 * @param string  $new_status The new status of the post.
 * @param string  $old_status The old status of the post.
 * @param WP_Post $post       The post object.
 */
function schedule_rag_script_on_publish($new_status, $old_status, $post) {
    // --- Guard Clauses: Check if we should proceed ---
    if ($new_status !== 'publish' || $old_status === 'publish' || get_post_type($post) !== 'post') {
        return;
    }

    // Schedule our custom event to run in 10 seconds.
    // We pass the post ID in an array so the next function can use it.
    wp_schedule_single_event(time() + 10, 'guilaw_run_delayed_rag_action', array($post->ID));
}

// Hook the SCHEDULER function to the post publishing action.
add_action('transition_post_status', 'schedule_rag_script_on_publish', 10, 3);


/**
 * 2. EXECUTES the delayed RAG script.
 *
 * This function is triggered by our custom WP-Cron event ('guilaw_run_delayed_rag_action').
 * It contains the actual logic to run the command-line script in the background.
 *
 * @param int $post_id The ID of the post to process.
 */
function execute_delayed_rag_script($post_id) {
    // --- Configuration & Command Execution ---
    $project_path = '/home/guilaw/public_html/app.kytisa.com/';
    $venv_path    = $project_path . 'rag/bin/activate';
    $script_name  = 'rag_app00.py';

    // Sanitize all parts of the command for security.
    $safe_venv_path    = escapeshellarg($venv_path);
    $safe_project_path = escapeshellarg($project_path);
    $safe_script_name  = escapeshellarg($script_name);
    $safe_arg1         = escapeshellarg('wp-single');
    $safe_post_id      = escapeshellarg($post_id);

    // Build the full command.
    $command = sprintf(
        'source %s && cd %s && python3 %s %s %s',
        $safe_venv_path,
        $safe_project_path,
        $safe_script_name,
        $safe_arg1,
        $safe_post_id
    );

    // Run the command in the background to avoid tying up server resources.
    shell_exec($command . " > /dev/null 2>&1 &");
}

// Hook the EXECUTOR function to our custom scheduled action.
add_action('guilaw_run_delayed_rag_action', 'execute_delayed_rag_script', 10, 1);
