jQuery(document).ready(function ($) {
    // Fetch subcategories dynamically
    $("#category").change(function () {
        var categoryId = $(this).val();
        var subcategoryDropdown = $("#subcategory");

        subcategoryDropdown.prop("disabled", true).html('<option value="">Chargement...</option>');

        if (categoryId) {
            $.ajax({
                type: "POST",
                url: ajaxsearch.ajaxurl,
                data: {
                    action: "get_subcategories",
                    parent_id: categoryId
                },
                success: function (response) {
                    subcategoryDropdown.html(response).prop("disabled", false);
                }
            });
        } else {
            subcategoryDropdown.html('<option value="">Select a category first</option>').prop("disabled", true);
        }
    });

    // Handle AJAX search
    $("#ajax-search-form").submit(function (e) {
        e.preventDefault();

        var searchData = $(this).serialize();
        var resultsContainer = $("#ajax-search-results");

        resultsContainer.html('<p>Chargement des résultats...</p>');

        $.ajax({
            type: "POST",
            url: ajaxsearch.ajaxurl,
            data: searchData + "&action=custom_ajax_search",
            success: function (response) {
                resultsContainer.html(response);
            }
        });
    });
});
