<?php
/*
Plugin Name: Mistral Chatbot
Description: Adds a popup Mistral chatbot to the bottom-right corner of each page.
Version: 1.5
Author: Your Name
*/











// Hook into 'wp' to safely access is_user_logged_in and user meta
add_action('wp', function () {
    if (!is_user_logged_in()) return;

$user       = wp_get_current_user();
$user_level = get_user_meta( $user->ID, 'custom_category_access_level', true );

if (
    in_array( 'administrator', (array) $user->roles, true )
    || $user_level === 'level_3'
    || $user_level === 'level_0'
) {


add_action('wp_enqueue_scripts', function () {
    // Load jQuery and Marked.js
    wp_enqueue_script('jquery');
    wp_enqueue_script('marked-js', 'https://cdn.jsdelivr.net/npm/marked/marked.min.js', array(), null, true);
    // Load Font Awesome for the copy icon
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');
    
    // Localize post data for all pages
    $post_data = array(
        'is_singular' => false,
        'content' => '',
        'title' => '',
        'permalink' => '',
        'site_name' => get_bloginfo('name'),
        'page_type' => 'general'
    );
    
    if (is_singular()) {
        global $post;
        $post_content = apply_filters('the_content', $post->post_content);
        $post_title = get_the_title($post->ID);
        $post_permalink = get_permalink($post->ID);
        
        $post_data = array(
            'content' => wp_strip_all_tags($post_content),
            'title' => $post_title,
            'permalink' => $post_permalink,
            'is_singular' => true,
            'site_name' => get_bloginfo('name'),
            'page_type' => get_post_type()
        );
    } elseif (is_home() || is_front_page()) {
        $post_data['page_type'] = 'homepage';
        $post_data['title'] = get_bloginfo('name') . ' - Home';
    } elseif (is_category()) {
        $post_data['page_type'] = 'category';
        $post_data['title'] = single_cat_title('', false);
    } elseif (is_tag()) {
        $post_data['page_type'] = 'tag';
        $post_data['title'] = single_tag_title('', false);
    } elseif (is_archive()) {
        $post_data['page_type'] = 'archive';
        $post_data['title'] = get_the_archive_title();
    }
    
    wp_localize_script('jquery', 'postData', $post_data);
});



add_action('wp_footer', function () {
    
    
    
    
    
    
    
    ?>
    <style>
    #mistral-chatbot-container {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 9999;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
    }

    #mistral-chat-toggle {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 15px;
        border-radius: 50%;
        cursor: pointer;
        font-size: 22px;
        text-align: center;
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: none;
        position: relative;
        overflow: hidden;
    }

    #mistral-chat-toggle::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    #mistral-chat-toggle:hover::before {
        opacity: 1;
    }

    #mistral-chat-toggle:hover {
        transform: translateY(-2px) scale(1.05);
        box-shadow: 0 12px 35px rgba(102, 126, 234, 0.6);
    }

    #mistral-chat-toggle span {
        position: relative;
        z-index: 1;
    }

    #mistral-chatbox {
        width: 350px;
        height: 480px;
        background: white;
        border: none;
        border-radius: 20px;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        margin-top: 15px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        backdrop-filter: blur(10px);
        transform: translateY(10px);
        opacity: 0;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    #mistral-chatbox:not(.hidden) {
        transform: translateY(0);
        opacity: 1;
    }

    #mistral-chatbox.hidden {
        display: none;
    }

    #chat-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 20px 20px 15px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        font-weight: 600;
        font-size: 16px;
        position: relative;
    }

    #chat-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: rgba(255, 255, 255, 0.2);
    }

    #clear-chat {
        background: rgba(255, 255, 255, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        color: white;
        cursor: pointer;
        font-size: 12px;
        padding: 6px 12px;
        border-radius: 15px;
        transition: all 0.2s ease;
        font-weight: 500;
    }

    #clear-chat:hover {
        background: rgba(255, 255, 255, 0.2);
        border-color: rgba(255, 255, 255, 0.3);
        transform: translateY(-1px);
    }

    #chatbox {
        flex: 1;
        padding: 20px;
        overflow-y: auto;
        font-size: 14px;
        background: linear-gradient(to bottom, #f8fafc, #f1f5f9);
        scrollbar-width: thin;
        scrollbar-color: #cbd5e1 transparent;
    }

    #chatbox::-webkit-scrollbar {
        width: 6px;
    }

    #chatbox::-webkit-scrollbar-track {
        background: transparent;
    }

    #chatbox::-webkit-scrollbar-thumb {
        background: #cbd5e1;
        border-radius: 3px;
    }

    #chatbox::-webkit-scrollbar-thumb:hover {
        background: #94a3b8;
    }

    #input-area {
        display: flex;
        border-top: 1px solid #e2e8f0;
        background: white;
        padding: 15px;
        gap: 10px;
    }

    #userInput {
        flex: 1;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        font-size: 14px;
        border-radius: 25px;
        outline: none;
        transition: all 0.2s ease;
        background: #f8fafc;
    }

    #userInput:focus {
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    #input-area button {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 12px 20px;
        cursor: pointer;
        font-size: 14px;
        border-radius: 25px;
        font-weight: 600;
        transition: all 0.2s ease;
        min-width: 70px;
    }

    #input-area button:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }

    #input-area button:active {
        transform: translateY(0);
    }

    .message {
        margin: 10px 0;
        padding: 12px 16px;
        border-radius: 18px;
        max-width: 85%;
        position: relative;
        line-height: 1.5;
        word-wrap: break-word;
        animation: messageSlide 0.3s ease-out;
    }

    @keyframes messageSlide {
        from {
            opacity: 0;
            transform: translateY(10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .message.user {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        align-self: flex-end;
        margin-left: auto;
        border-bottom-right-radius: 6px;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .message.assistant {
        background: white;
        color: #374151;
        align-self: flex-start;
        border: 1px solid #e5e7eb;
        border-bottom-left-radius: 6px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
    }

    .message.system {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        align-self: center;
        margin: 10px auto;
        border-radius: 15px;
        font-size: 13px;
        text-align: center;
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
        max-width: 95%;
    }

    .message-actions {
        position: absolute;
        top: 8px;
        right: 8px;
        opacity: 0;
        transition: opacity 0.2s ease;
    }

    .message:hover .message-actions {
        opacity: 1;
    }

    .message.user .message-actions {
        right: 8px;
    }

    .message.assistant .message-actions {
        right: 8px;
    }

    .btn {
        display: inline-block;
        font-weight: 500;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        user-select: none;
        border: 1px solid transparent;
        padding: 6px 10px;
        font-size: 12px;
        line-height: 1.4;
        border-radius: 12px;
        transition: all 0.2s ease;
        cursor: pointer;
    }

    .btn-sm {
        padding: 4px 8px;
        font-size: 11px;
        border-radius: 10px;
    }

    .btn-outline {
        color: #6b7280;
        background-color: rgba(255, 255, 255, 0.9);
        border-color: #d1d5db;
        backdrop-filter: blur(5px);
    }

    .btn-outline:hover {
        color: white;
        background-color: #6b7280;
        border-color: #6b7280;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(107, 114, 128, 0.3);
    }

    .message.user .btn-outline {
        color: rgba(255, 255, 255, 0.8);
        background-color: rgba(255, 255, 255, 0.1);
        border-color: rgba(255, 255, 255, 0.2);
    }

    .message.user .btn-outline:hover {
        color: white;
        background-color: rgba(255, 255, 255, 0.2);
        border-color: rgba(255, 255, 255, 0.3);
    }

    /* Markdown styling within messages */
    .message p {
        margin: 0 0 8px 0;
    }

    .message p:last-child {
        margin-bottom: 0;
    }

    .message code {
        background: rgba(0, 0, 0, 0.1);
        padding: 2px 6px;
        border-radius: 4px;
        font-size: 12px;
        font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
    }

    .message.user code {
        background: rgba(255, 255, 255, 0.2);
    }

    .message pre {
        background: rgba(0, 0, 0, 0.05);
        padding: 10px;
        border-radius: 8px;
        overflow-x: auto;
        margin: 8px 0;
    }

    .message.user pre {
        background: rgba(255, 255, 255, 0.1);
    }

    .message ul, .message ol {
        margin: 8px 0;
        padding-left: 20px;
    }

    .message li {
        margin: 4px 0;
    }

    /* Mobile responsiveness */
    @media (max-width: 768px) {
        #mistral-chatbot-container {
            bottom: 15px;
            right: 15px;
        }
        
        #mistral-chatbox {
            width: 300px;
            height: 400px;
        }
        
        #chat-header {
            padding: 15px;
        }
        
        #chatbox {
            padding: 15px;
        }
        
        #input-area {
            padding: 12px;
        }
        
        .message {
            max-width: 90%;
        }
    }

    /* Loading animation for streaming */
    .message.assistant.loading::after {
        content: '●●●';
        animation: loading 1.5s infinite;
        opacity: 0.5;
    }

    @keyframes loading {
        0%, 60%, 100% { opacity: 0.5; }
        30% { opacity: 1; }
    }
    </style>

    <div id="mistral-chatbot-container">
        <div id="mistral-chat-toggle"><span>💬</span></div>
        <div id="mistral-chatbox" class="hidden">
            <div id="chat-header">
                <span>Kytisa Assistant</span>
                <button id="clear-chat">Clear Chat</button>
            </div>
            <div id="chatbox"></div>
            <div id="input-area">
                <input type="text" id="userInput" placeholder="Ask me anything..." />
                <button onclick="sendMessage()">Send</button>
            </div>
        </div>
    </div>

    <script>
    jQuery(document).ready(function ($) {
        
        
        
        const apiKey = 'RCkYwM0ZTF85CVMVzOCbTtEYcAjwrNsC'; // Replace securely in production
    
        const apiUrl = 'https://api.mistral.ai/v1/chat/completions';
        const globalSessionKey = 'mistral_chat_global_session'; // Global conversation
        const currentPageKey = 'mistral_current_page';
        
        // Get current page info
        const currentPageInfo = {
            url: window.location.href,
            title: postData.title || document.title,
            is_singular: postData.is_singular || false,
            page_type: postData.page_type || 'general'
        };
        
        // Create dynamic system prompt based on current page
        function createSystemPrompt() {
            let basePrompt = "You are a helpful AI assistant. Answer questions helpfully and concisely.";
            
            if (postData.is_singular && postData.content) {
                basePrompt = `Kytisa, votre assistant IA, dispose des informations relatives à l’article en cours intitulé.. "${postData.title}".
                
                Article content: ${postData.content}
                Article URL: ${postData.permalink}
                
                When users ask about "this article", "this post", or "this page", refer to the above content.
                For general questions not related to the article, respond normally with your general knowledge.`;
            } else if (postData.page_type === 'homepage') {
                basePrompt = `You are a helpful AI assistant for ${postData.site_name}. You're currently on the homepage.
                You can help with general questions and information about this website.`;
            } else if (postData.page_type === 'category' || postData.page_type === 'tag' || postData.page_type === 'archive') {
                basePrompt = `You are a helpful AI assistant for ${postData.site_name}. You're currently on a ${postData.page_type} page: "${postData.title}".
                You can help with general questions and information about this website.`;
            }
            
            return {
                role: "system",
                content: basePrompt
            };
        }
        
        // Load global conversation history
        let conversationHistory = JSON.parse(localStorage.getItem(globalSessionKey)) || [];
        let lastPageInfo = JSON.parse(localStorage.getItem(currentPageKey)) || {};
        
        // Check if user navigated to a different page/post
        const pageChanged = lastPageInfo.url !== currentPageInfo.url;
        
        // Initialize conversation if empty or update system prompt if page changed
        if (conversationHistory.length === 0) {
            conversationHistory = [createSystemPrompt()];
        } else if (pageChanged && (postData.is_singular || lastPageInfo.is_singular)) {
            // Update system prompt when moving between posts or from/to posts
            conversationHistory[0] = createSystemPrompt();
        }
        
        // Add welcome/navigation message when page changes
        if (pageChanged && conversationHistory.length > 1) {
            let navigationMessage = '';
            
            if (postData.is_singular) {
                navigationMessage = `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ? "${postData.title}"?`;
            } else if (postData.page_type === 'homepage') {
                navigationMessage = `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ? ${postData.site_name}?`;
            } else {
                navigationMessage = `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ?`;
            }
            
            // Add system message about page change (this won't be sent to API)
            if (navigationMessage) {
                setTimeout(() => {
                    appendSystemMessage(navigationMessage);
                }, 500);
            }
        } else if (conversationHistory.length === 1) {
            // First time visitor
            let welcomeMessage = '';
            
            if (postData.is_singular) {
                welcomeMessage = `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ? "${postData.title}"?`;
            } else if (postData.page_type === 'homepage') {
                welcomeMessage = `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ? ${postData.site_name}?`;
            } else {
                welcomeMessage = `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ?`;
            }
            
            setTimeout(() => {
                appendSystemMessage(welcomeMessage);
            }, 1000);
        }
        
        // Save current page info
        localStorage.setItem(currentPageKey, JSON.stringify(currentPageInfo));
        
        // Display previous messages (excluding system prompt)
        displayConversationHistory();
        
        $('#mistral-chat-toggle').click(function () {
            $('#mistral-chatbox').toggleClass('hidden');
        });

        $('#clear-chat').click(function() {
            if (confirm('Êtes-vous sûr de vouloir effacer tout l’historique de discussion ?')) {
                conversationHistory = [createSystemPrompt()];
                localStorage.setItem(globalSessionKey, JSON.stringify(conversationHistory));
                $('#chatbox').empty();
                
                // Show welcome message after clearing
                setTimeout(() => {
                    let welcomeMessage = postData.is_singular 
                        ? `👋 Bonjour ! Je suis là pour vous aider. Que puis-je faire pour vous concernant l’article ? "${postData.title}"?`
                        : `👋 Bonjour ! Je suis votre assistant. Comment puis-je vous aider ?`;
                    appendSystemMessage(welcomeMessage);
                }, 500);
            }
        });

        // Handle Enter key press
        $('#userInput').keypress(function (e) {
            if (e.which == 13) {
                sendMessage();
            }
        });

        // Copy message to clipboard
        window.copyMessage = function(button) {
            const messageContent = $(button).closest('.message').clone().find('.message-actions').remove().end().text().trim();
            navigator.clipboard.writeText(messageContent).then(function() {
                const icon = $(button).find('i');
                icon.removeClass('fa-copy').addClass('fa-check');
                setTimeout(function() {
                    icon.removeClass('fa-check').addClass('fa-copy');
                }, 2000);
            }, function() {
                alert('Failed to copy message');
            });
        };

        window.sendMessage = function () {
            const input = $('#userInput');
            const userText = input.val().trim();
            if (!userText) return;

            appendMessage('user', userText);
            conversationHistory.push({ role: 'user', content: userText });
            saveConversation();
            input.val('');

            const assistantDiv = $('<div>').addClass('message assistant').html('');
            const actionsDiv = $('<div>').addClass('message-actions').html(`
                <button class="btn btn-sm btn-outline" onclick="copyMessage(this)"><i class="fas fa-copy"></i></button>
            `);
            assistantDiv.append(actionsDiv);
            $('#chatbox').append(assistantDiv);
            $('#chatbox').scrollTop($('#chatbox')[0].scrollHeight);

            const payload = {
                model: 'mistral-large-latest',
                messages: conversationHistory,
                temperature: 0.6,
                stream: true
            };

            $.ajax({
                url: apiUrl,
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + apiKey
                },
                data: JSON.stringify(payload),
                xhrFields: {
                    onprogress: function (e) {
                        const response = e.currentTarget.response;
                        const lines = response.split('\n');
                        let buffer = '';

                        for (const line of lines) {
                            if (line.startsWith('data: ')) {
                                const jsonStr = line.slice(6).trim();
                                if (jsonStr === '[DONE]') {
                                    conversationHistory.push({ role: 'assistant', content: buffer });
                                    saveConversation();
                                    break;
                                }

                                try {
                                    const data = JSON.parse(jsonStr);
                                    const token = data.choices?.[0]?.delta?.content;
                                    if (token) {
                                        buffer += token;
                                        assistantDiv.html(marked.parse(buffer) + actionsDiv[0].outerHTML);
                                        $('#chatbox').scrollTop($('#chatbox')[0].scrollHeight);
                                    }
                                } catch (e) {
                                    console.error('Stream parse error:', e);
                                }
                            }
                        }
                    }
                }
            }).fail(function (jqXHR, textStatus, errorThrown) {
                assistantDiv.text('Error: ' + textStatus + ' - ' + errorThrown);
            });
        };

        function appendMessage(role, content) {
            const chatbox = $('#chatbox');
            const div = $('<div>').addClass('message ' + (role === 'user' ? 'user' : 'assistant'));
            
            if (role === 'assistant') {
                const actionsDiv = $('<div>').addClass('message-actions').html(`
                    <button class="btn btn-sm btn-outline" onclick="copyMessage(this)"><i class="fas fa-copy"></i></button>
                `);
                div.append(actionsDiv);
            }
            
            div.append(marked.parse(content));
            chatbox.append(div);
            chatbox.scrollTop(chatbox[0].scrollHeight);
        }
        
        function appendSystemMessage(content) {
            const chatbox = $('#chatbox');
            const div = $('<div>').addClass('message system');
            div.html(content);
            chatbox.append(div);
            chatbox.scrollTop(chatbox[0].scrollHeight);
        }
        
        function displayConversationHistory() {
            // Display previous messages (excluding system prompt)
            if (conversationHistory.length > 1) {
                conversationHistory.slice(1).forEach(msg => {
                    if (msg.role !== 'system') {
                        appendMessage(msg.role, msg.content);
                    }
                });
            }
        }
        
        function saveConversation() {
            localStorage.setItem(globalSessionKey, JSON.stringify(conversationHistory));
        }
    });
    </script>
    <?php
});


    }
});






